const int displayFreqVertikaalOffset = 40;

void InitScreen()
{
  myGLCD.InitLCD();
  myGLCD.clrScr();

  myTouch.InitTouch();
  myTouch.setPrecision(PREC_MEDIUM);
}

void drawButtons()
{
  int horizontaalOffSet = 0;
  int vertikaalOffSetPlus = 10 + displayFreqVertikaalOffset;
  int vertikaalOffSetMin = 110 + displayFreqVertikaalOffset;

  myGLCD.setFont(BigFont);

  // Plus button
  createPlusMinButtons(2, horizontaalOffSet, vertikaalOffSetPlus, "+");
  createPlusMinButtons(3, horizontaalOffSet + 66, vertikaalOffSetPlus, "+");
  createPlusMinButtons(3, horizontaalOffSet + 164, vertikaalOffSetPlus, "+");

  // Min button
  createPlusMinButtons(2, horizontaalOffSet, vertikaalOffSetMin, "-");
  createPlusMinButtons(3, horizontaalOffSet + 66, vertikaalOffSetMin, "-");
  createPlusMinButtons(3, horizontaalOffSet + 164, vertikaalOffSetMin, "-");

  createRestButtons();
}

void createPlusMinButtons(int aantal, int horizontaalPos, int vertikaalOffSet, String teken)
{
  for (int x = 0; x < aantal; x++)
  {
    myGLCD.setColor(0, 0, 255);
    myGLCD.fillRoundRect (horizontaalPos + 1 + (x * 32), vertikaalOffSet, horizontaalPos + 1 + 30 + (x * 32), vertikaalOffSet + 30);
    myGLCD.setColor(255, 255, 255);
    myGLCD.setBackColor(0, 0, 255);
    myGLCD.drawRoundRect (horizontaalPos + 1 + (x * 32), vertikaalOffSet, horizontaalPos + 1 + 30 + (x * 32), vertikaalOffSet + 30);
    myGLCD.print(teken, horizontaalPos + (x * 32) + 8, vertikaalOffSet + 7);
  }
}

void createRestButtons()
{
  int vertikaalOffSet = 205;
  int horizontaalPos = 0;

  // Step button
  setStepButton(vertikaalOffSet, horizontaalPos);

  // Plus / Min button
  createPlusMinButtons(1, horizontaalPos + 95, vertikaalOffSet, "-");
  createPlusMinButtons(1, horizontaalPos + 95 + 35, vertikaalOffSet, "+");

  // Mem button
  horizontaalPos = 164;
  myGLCD.setFont(BigFont);
  myGLCD.setColor(0, 0, 255);
  myGLCD.fillRoundRect (horizontaalPos, vertikaalOffSet, horizontaalPos + 60, vertikaalOffSet + 30);
  myGLCD.setColor(VGA_YELLOW);
  myGLCD.setBackColor(0, 0, 255);
  myGLCD.drawRoundRect (horizontaalPos, vertikaalOffSet, horizontaalPos + 60, vertikaalOffSet + 30);
  myGLCD.print("Mem", horizontaalPos + 5, vertikaalOffSet + 7);

  // Reset button
  horizontaalPos = 229;
  myGLCD.setFont(BigFont);
  myGLCD.setColor(0, 0, 255);
  myGLCD.fillRoundRect (horizontaalPos, vertikaalOffSet, horizontaalPos + 90, vertikaalOffSet + 30);
  myGLCD.setColor(VGA_RED);
  myGLCD.setBackColor(0, 0, 255);
  myGLCD.drawRoundRect (horizontaalPos, vertikaalOffSet, horizontaalPos + 90, vertikaalOffSet + 30);
  myGLCD.print("Reset", horizontaalPos + 5, vertikaalOffSet + 7);
}

void setStepButton(int vertikaalOffSet, int horizontaalPos)
{
  myGLCD.setFont(SmallFont);
  myGLCD.setColor(0, 0, 255);
  myGLCD.fillRoundRect (horizontaalPos, vertikaalOffSet, horizontaalPos + 90, vertikaalOffSet + 30);
  myGLCD.setColor(VGA_YELLOW);
  myGLCD.setBackColor(0, 0, 255);
  myGLCD.drawRoundRect (horizontaalPos, vertikaalOffSet, horizontaalPos + 90, vertikaalOffSet + 30);
  myGLCD.print(_StepTekst[_StepIndex], horizontaalPos + 20, vertikaalOffSet + 10);
}

// Draw a red frame while a button is touched
void waitForIt(int x1, int y1, int x2, int y2)
{
  myGLCD.setColor(255, 0, 0);
  myGLCD.drawRoundRect (x1, y1, x2, y2);
  while (myTouch.dataAvailable())
    myTouch.read();
  myGLCD.setColor(255, 255, 255);
  myGLCD.drawRoundRect (x1, y1, x2, y2);
}



