#include <UTFT.h>
#include <UTouch.h>

UTFT    myGLCD(SSD1289, 38, 39, 40, 41);
UTouch  myTouch( 42, 43, 44, 45, 46);

extern uint8_t SmallFont[];
extern uint8_t BigFont[];
extern uint8_t SevenSegNumFont[];

String _Frequentie = "00000000";

int _StepGrote[] = {10, 50, 100, 500, 1000, 2500, 5000, 10000, 100000, 1000000};
int _StepIndex = 0;
String _StepTekst[] = {"10 Hz", "50 Hz", "100 Hz", "500 Hz", "1 Khz", "2,5 Khz", "5 Khz", "10 Khz", "100 Khz", "1 Mhz"};


void setup() {
  // put your setup code here, to run once:
  Serial.begin(9600);

  // ivm display opstarten cold boot
  delay(500);

  InitScreen();

  initDDS();

  startScherm();
}

void loop() {
  // put your main code here, to run repeatedly:

  if (handleButton())
  {
    ShowFrequence(_Frequentie);
    SetFrequency(_Frequentie.toInt());
  }
}

void startScherm()
{
  myGLCD.setFont(BigFont);

  ShowFrequence(_Frequentie);

  drawButtons();

  myGLCD.setFont(BigFont);
  myGLCD.setColor(VGA_LIME);
  myGLCD.setBackColor(0, 0, 0);
  myGLCD.print("Signaal generator", CENTER, 5);
  myGLCD.setFont(SmallFont);
  myGLCD.print("(AD9850 Module)", RIGHT, 25);
}

