/*
   InternalClockSync.ino
   example code illustrating time synced from a DCF77 receiver
   Thijs Elenbaas, 2012
   This example code is in the public domain.

  This example shows how to fetch a DCF77 time and synchronize
  the internal clock. In order for this example to give clear output,
  make sure that you disable logging  from the DCF library. You can
  do this by commenting out   #define VERBOSE_DEBUG 1   in Utils.cpp.

  NOTE: If you used a package manager to download the DCF77 library,
  make sure have also fetched these libraries:

   Time

  A package that includes all referenced libraries can be found at:
  https://github.com/thijse/Zipballs/blob/master/DCF77/DCF77.zip?raw=true

  Pin connectie

  |                 |
  |                 |
  |                 |
  |    O O O O      |
  -------------------
     4 3 2 1

  1 GND
  2 VCC +1,5 tot +15 V
  3 OUT
  4 OUT geinverteerd

  Pin 3, 4 moeten via een pullup weerstan naar VCC

*/


#include <LiquidCrystal.h>
LiquidCrystal lcd(12, 11, 10, 9, 8, 7);

#include "DCF77.h"
#include "TimeLib.h"


#define DCF_PIN 2	         // Connection pin 3 to DCF 77 device
#define DCF_PIN_heart 3    // Connection pin 3 to DCF 77 device
#define DCF_PIN_power 4    // Power
#define DCF_INTERRUPT 0		 // Interrupt number associated with pin

time_t time;
DCF77 DCF = DCF77(DCF_PIN, DCF_INTERRUPT);

byte heart[8] = {
  0b00000,
  0b01010,
  0b11111,
  0b11111,
  0b11111,
  0b01110,
  0b00100,
  0b00000
};

byte armsUp[8] = {
  0b00100,
  0b01010,
  0b00100,
  0b10101,
  0b01110,
  0b00100,
  0b00100,
  0b01010
};

void setup() {
  Serial.begin(9600);

  lcd.begin(16, 2);
  lcd.clear();

  lcd.createChar(0, heart);
  lcd.createChar(1, armsUp);

  pinMode(DCF_PIN_heart, INPUT);
  pinMode(DCF_PIN_power, OUTPUT);

  digitalWrite(DCF_PIN_power, HIGH);
  DCF.Start();
  Serial.println("Waiting for DCF77 time ... ");
  Serial.println("It will take at least 2 minutes until a first update can be processed.");
}

void loop() {
  delay(100); //1000

  if (minute() == 00 && second() < 3)
  {
    digitalWrite(DCF_PIN_power, HIGH);

    lcd.setCursor(12, 1);
    lcd.print(".");
    DCF.Start();
  }

  time_t DCFtime = DCF.getTime(); // Check if new DCF77 time is available
  if (DCFtime != 0)
  {
    lcd.setCursor(12, 1);
    // lcd.print("Time ok");
    lcd.write(byte(1));
    Serial.println("Time is updated");
    setTime(DCFtime);
    digitalWrite(DCF_PIN_power, LOW);
  }

  lcd.setCursor(12, 0);
  if (digitalRead(DCF_PIN_heart))
  {
    lcd.print(" ");
  }
  else
  {
    lcd.write(byte(0));
  }

  digitalClockDisplay();
}

void digitalClockDisplay() {
  // digital clock display of the time

  lcd.setCursor(0, 0);

  lcdDigits(hour());
  lcd.print(":");
  lcdDigits(minute());
  lcd.print(":");
  lcdDigits(second());

  lcd.setCursor(0, 1);

  lcdDigits(day());
  lcd.print("-");
  lcdDigits(month());
  lcd.print("-");
  lcd.print(year());


  Serial.print(hour());
  printDigits(minute());
  printDigits(second());
  Serial.print(" ");
  Serial.print(day());
  Serial.print(" ");
  Serial.print(month());
  Serial.print(" ");
  Serial.print(year());
  Serial.println();
}

void printDigits(int digits) {
  // utility function for digital clock display: prints preceding colon and leading 0
  Serial.print(":");
  if (digits < 10)
    Serial.print('0');
  Serial.print(digits);
}

void lcdDigits(int digits) {
  // utility function for digital clock display: prints preceding colon and leading 0
  // lcd.print(":");
  if (digits < 10)
    lcd.print('0');
  lcd.print(digits);
}
