#include <SoftwareSerial.h>
#include <TinyGPS.h>
#include <LiquidCrystal.h>

TinyGPS gps;
SoftwareSerial ss(7, 8);

LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

static void smartdelay(unsigned long ms);
static void print_int(unsigned long val, unsigned long invalid, int len);
static void print_float(float val, float invalid, int len, int prec);

void setup()
{
  lcd.begin(16, 2);

  Serial.begin(9600);
  ss.begin(9600);


}

void loop()
{
  unsigned short failed = 0;
  unsigned long chars = 0;
  unsigned short sentences = 0;
  unsigned long age;
  float flat;
  float flon;

  int satellites = gps.satellites();
  float speed_kmph = gps.f_speed_kmph();

  print_int(satellites, TinyGPS::GPS_INVALID_SATELLITES, 5);
  print_float(speed_kmph, TinyGPS::GPS_INVALID_F_SPEED, 6, 1);

  gps.stats(&chars, &sentences, &failed);
  gps.f_get_position(&flat, &flon, &age);
  print_int(failed, 0xFFFFFFFF, 9);

  Serial.println();


  lcd.setCursor(0, 0);
  lcd.print("Fix: ");
  String fix = "";

  switch (gps.fixQuality())
  {
    case 0:
      fix = "no";
      break;

    case 1:
      fix = "ok";
      break;

    case 2:
      fix = "3D";
      break;
  }

  lcd.print(fix);

  lcd.setCursor(8, 0);
  lcd.print("sat.# ");

  if (satellites == TinyGPS::GPS_INVALID_SATELLITES)
  {
    lcd.print ("--");
  }
  else
  {
    int satelieten = gps.satellites();
    if (satelieten < 10)
      lcd.print(0);
    lcd.print(satelieten);
  }
  lcd.setCursor(3, 1);

  if (speed_kmph == TinyGPS::GPS_INVALID_F_SPEED)
  {
    lcd.print("----");
  }
  else
  {
    lcd.print(gps.f_speed_kmph());
  }
  lcd.print(" KM/h  ");


  smartdelay(1000);

}
