/*
  Arduino Nano is used
  Sensor pin    Arduino pin
  VCC           5 Volt
  GND           GND
  OUT           D2

  Led op D13
*/

int inputPin = 2;
int ledPinRed = 3;
int ledPinGreen = 4;

void setup() {
  Serial.begin(9600);

  pinMode(inputPin, INPUT); // Sensor output
  
  pinMode(ledPinRed, OUTPUT);   // Led Red
  digitalWrite(ledPinRed, LOW); // Initialize Led
  pinMode(ledPinGreen, OUTPUT);   // Led Green
  digitalWrite(ledPinGreen, LOW); // Initialize Led
}

void loop() {

  bool inRange = (!digitalRead(inputPin));

  if (inRange)
  {
    Serial.println("In range");
    digitalWrite(ledPinRed, HIGH);
    digitalWrite(ledPinGreen, LOW);
  }
  else
  {
    Serial.println("Not in range");
    digitalWrite(ledPinGreen, HIGH);
    digitalWrite(ledPinRed, LOW);
  }

  delay(100);
}
