//-------------------------------------------------------------------------------------
// HX711_ADC.h
// Arduino master library for HX711 24-Bit Analog-to-Digital Converter for Weigh Scales
// Olav Kallhovd sept2017
// Tested with      : HX711 asian module on channel A and YZC-133 3kg load cell
// Tested with MCU  : Arduino Nano
//-------------------------------------------------------------------------------------
// This is an example sketch on how to use this library
// Settling time (number of samples) and data filtering can be adjusted in the HX711_ADC.h file

#include <HX711_ADC.h>

#include <LiquidCrystal.h>
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

byte euro[8] = {
  0b00110,
  0b01001,
  0b10000,
  0b11110,
  0b10000,
  0b11110,
  0b01001,
  0b00110
};

//HX711 constructor (dout pin, sck pin)
HX711_ADC LoadCell(6, 7);

long t;

void setup() {
  lcd.begin(16, 2);
  lcd.createChar(1, euro);

  lcd.setCursor(0, 0);
  lcd.print("Wait...");

  Serial.begin(9600);
  Serial.println("Wait...");
  LoadCell.begin();
  long stabilisingtime = 2000; // tare preciscion can be improved by adding a few seconds of stabilising time
  LoadCell.start(stabilisingtime);
  LoadCell.setCalFactor(450.0); // user set calibration factor (float)
  Serial.println("Startup + tare is complete");

  lcd.clear();
}

void loop() {
  //update() should be called at least as often as HX711 sample rate; >10Hz@10SPS, >80Hz@80SPS
  //longer delay in scetch will reduce effective sample rate (be carefull with delay() in loop)
  LoadCell.update();

  //get smoothed value from data set + current calibration factor
  if (millis() > t + 250) {
    float value = LoadCell.getData();
    Serial.print("Load_cell output val: ");
    Serial.println(value);
    t = millis();

    // round to whole grams
    int i = value;

    lcd.setCursor(0, 0);
    lcd.print(i);
    lcd.print(" gr     ");

    lcd.setCursor(8, 0);
    lcd.print(value);
    lcd.print("  ");

    int aantal = 0;

    if (i > 0.1 && i <= 20)
    {
      aantal = 1;
    }
    else if (i > 20 && i <= 50)
    {
      aantal = 2;
    }
    else if (i > 50 && i <= 100)
    {
      aantal = 3;
    }
    else if (i > 100 && i <= 250)
    {
      aantal = 4;
    }
    else if (i > 250 && i <= 2000)
    {
      aantal = 5;
    }

    if (i > 0)
    {

      lcd.setCursor(0, 1);
      lcd.print(aantal);
      lcd.print(" zegel");
      if (aantal > 1)
      {
        lcd.print("s");
      }
      float bedrag = aantal * 0.78;

      lcd.setCursor(9, 1);
      lcd.write(1);
      lcd.print(" ");
      lcd.print(bedrag);
    }
    else
    {
      lcd.setCursor(0, 1);
      lcd.print("                ");
    }
  }

  //receive from serial terminal
  if (Serial.available() > 0) {
    float i;
    char inByte = Serial.read();
    if (inByte == 't') LoadCell.tareNoDelay();
  }

  //check if last tare operation is complete
  if (LoadCell.getTareStatus() == true) {
    Serial.println("Tare complete");
  }



}
