//-------------------------------------------------------------------------------------
// HX711_ADC.h
// Arduino master library for HX711 24-Bit Analog-to-Digital Converter for Weigh Scales
// Olav Kallhovd sept2017
// Tested with      : HX711 asian module on channel A and YZC-133 3kg load cell
// Tested with MCU  : Arduino Nano
//-------------------------------------------------------------------------------------
// This is an example sketch on how to use this library
// Settling time (number of samples) and data filtering can be adjusted in the HX711_ADC.h file

#include <HX711_ADC.h>
#include <Math.h>

#include <LiquidCrystal.h>
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

//HX711 constructor (dout pin, sck pin)
HX711_ADC LoadCell(6, 7);

long t;

void setup() {
  lcd.begin(16, 2);

  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Wait...");

  Serial.begin(9600);
  Serial.println("Wait...");
  LoadCell.begin();
  long stabilisingtime = 2000; // tare preciscion can be improved by adding a few seconds of stabilising time
  LoadCell.start(stabilisingtime);
  LoadCell.setCalFactor(450.0); // user set calibration factor (float)

  lcd.clear();
  lcd.print("Rijst weegschaal");
}

void loop() {
  //update() should be called at least as often as HX711 sample rate; >10Hz@10SPS, >80Hz@80SPS
  //longer delay in scetch will reduce effective sample rate (be carefull with delay() in loop)
  LoadCell.update();

  //get smoothed value from data set + current calibration factor
  if (millis() > t + 250) {
    float value = LoadCell.getData();
    //    Serial.print("Load_cell output val: ");
    Serial.println(value);
    t = millis();

    if (value > 0.2)
    {
      // 75 gram / person
      value = value / 75;

      int roundValue = value;
      int decimalValue = round((value - roundValue) * 10 + 0.05);

      lcd.setCursor(0, 1);
      lcd.print("pers: ");
      lcd.print(roundValue);

      lcd.print(",");
      lcd.print(decimalValue);
      lcd.print("  ");
    }
  }

  //receive from serial terminal
  if (Serial.available() > 0) {
    float i;
    char inByte = Serial.read();
    if (inByte == 't')
    {
      lcd.clear();
      lcd.setCursor(0, 0);
      lcd.print("Wait... Tare");

      LoadCell.tareNoDelay();
    }
  }

  //check if last tare operation is complete
  if (LoadCell.getTareStatus() == true) {
    Serial.println("Tare complete");

    lcd.clear();
    lcd.print("Tare complete");
    
    delay(2000);

    lcd.clear();
    lcd.print("Rijst weegschaal");
  }



}
