#include <SoftwareSerial.h>

#include <LiquidCrystal.h>
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

/*
  Nano aansluitingen
  Inverter 74LS04, hardware data inverteren
  Nano                     P1 slimme meter
  D10    <-- inverter      5
  D4     --> 2x inverter   2
  GND                      GND
*/


const int requestPin =  7;

SoftwareSerial altSerial(10, 9); // RX, TX, inverted  Alleen RX van toepassing

char input; // inkomende seriele data (byte)
bool readnextLine = false;
#define BUFSIZE 75
char buffer[BUFSIZE]; //Buffer voor seriele data om \n te vinden.
int bufpos = 0;
long mEVLT = 0; //Meterstand Elektra - verbruik laag tarief
long mEVHT = 0; //Meterstand Elektra - verbruik hoog tarief
long mETLT = 0; //Meterstand Elektra - teruglevering laag tarief
long mETHT = 0; //Meterstand Elektra - teruglevering hoog tarief
long mEAV = 0;  //Meterstand Elektra - actueel verbruik
long mEAT = 0;  //Meterstand Elektra - actueel teruglevering
float mG = 0;   //Meterstand Gas

long a1;
long a2;
long a3;


void setup() {
  Serial.begin(9600);
  altSerial.begin(9600);

  pinMode(requestPin, OUTPUT);
  digitalWrite(requestPin, HIGH);

  //  digitalWrite(requestPin, LOW);

  lcd.begin(16, 2);
  lcd.clear();

  lcd.print("Start slimme mtr");
  delay(2000);
  lcd.clear();
}

void loop() {



  long tl = 0;
  long tld = 0;



  if (altSerial.available()) {



    input = altSerial.read();



    // --- 7 bits instelling ---
    input &= ~(1 << 7);
    char inChar = (char)input;
    // --- 7 bits instelling ---

    Serial.print(input); //Debug

    // Vul buffer tot en met een nieuwe lijn (\n)
    buffer[bufpos] = input & 127;
    bufpos++;

    if (input == '\n') { // we hebben een lijn binnen (gegevens tot \n)

      // 1-0:1.8.1 = Elektra verbruik laag tarief (DSMR v4.0)
      if (sscanf(buffer, "1-0:1.8.1(%ld%.%ld%*s" , &tl, &tld) > 0 ) {
        mEVLT = tl * 1000 + tld;
        if (mEVLT > 0) {
          Serial.print("Elektra - meterstand verbruik LAAG tarief (Wh): ");
          Serial.println(mEVLT);
          a1 = mEVLT;
          mEVLT = 0;
        }
      }

      // 1-0:1.8.2 = Elektra verbruik hoog tarief (DSMR v4.0)
      if (sscanf(buffer, "1-0:1.8.2(%ld%.%ld%*s" , &tl, &tld) > 0 ) {
        mEVHT = tl * 1000 + tld;
        if (mEVHT > 0) {
          Serial.print("Elektra - meterstand verbruik HOOG tarief (Wh): ");
          Serial.println(mEVHT);

          a2 = mEVHT;

          mEVHT = 0;
        }
      }

      // 1-0:1.7.0 = Elektra actueel verbruik (DSMR v4.0)
      if (sscanf(buffer, "1-0:1.7.0(%ld.%ld%*s" , &tl , &tld) > 0 ) {
        mEAV = tl * 1000 + tld * 10;
        if (mEAV > 0) {
          Serial.print("Elektra - actueel verbruik (W): ");
          Serial.println(mEAV);

          a3 = mEAV;

          mEAV = 0;
        }
      }

      // 1-0:2.8.1 = Elektra teruglevering hoog tarief (DSMR v4.0)
      if (sscanf(buffer, "1-0:2.8.1(%ld%.%ld%*s" , &tl, &tld) > 0 ) {
        mETLT = tl * 1000 + tld;
        if (mETLT > 0) {
          Serial.print("Elektra - meterstand teruglevering LAAG tarief (Wh): ");
          Serial.println(mETLT);
          mETLT = 0;
        }
      }

      // 1-0:2.8.2 = Elektra teruglevering hoog tarief (DSMR v4.0)
      if (sscanf(buffer, "1-0:2.8.2(%ld%.%ld%*s" , &tl, &tld) > 0 ) {
        mETHT = tl * 1000 + tld;
        if (mETHT > 0) {
          Serial.print("Elektra - meterstand teruglevering HOOG tarief (Wh): ");
          Serial.println(mETHT);
          mETHT = 0;
        }
      }

      // 1-0:2.7.0 = Elektra actueel teruglevering (DSMR v4.0)
      if (sscanf(buffer, "1-0:2.7.0(%ld.%ld%*s" , &tl , &tld) > 0  ) {
        mEAT = tl * 1000 + tld * 10;
        if (mEAT > 0) {
          Serial.print("Elektra - actueel teruglevering (W): ");
          Serial.println(mEAT);
          mEAT = 0;
        }
      }

      // 0-1:24.3.0 = Gas (DSMR v4.0)
      if (sscanf(buffer, "0-1:24.3.0(%6ld%4ld%*s" , &tl, &tld) > 0  ) {
        readnextLine = true; // we moeten de volgende lijn hebben
      }
      if (readnextLine) {
        if (sscanf(buffer, "(%ld.%ld%*s" , &tl, &tld) > 0  ) {
          mG = float ( tl * 1000 + tld ) / 1000;
          Serial.print("Gas - meterstand (m3): ");
          Serial.println(mG);
          Serial.println("");


          lcd.setCursor(0, 0);
          lcd.print(" I:");
          lcd.print((int)(a1 / 1000));

          lcd.setCursor(9, 0);
          lcd.print("II:");
          lcd.print((int)(a2 / 1000));

          lcd.setCursor(0, 1);
          lcd.print("Ac:");
          lcd.print(a3);
          lcd.print("  ");

          lcd.setCursor(9, 1);
          lcd.print("gs:");
          lcd.print((int)mG);

          readnextLine = false;
        }
      }

      // Maak de buffer weer leeg (hele array)
      for (int i = 0; i < 75; i++)
      {
        buffer[i] = 0;
      }
      bufpos = 0;
    }
  }


  //digitalWrite(requestPin, LOW);


}
