bool calc(float dth22Temp, float dth22Humidity, float wandTemp)
{
  float A = log(dth22Humidity / 100) / log(2.718282) + (17.62 * dth22Temp / (243.12 + dth22Temp));
  float dp = 243.12 * A / (17.62 - A);
  _Dauwpunt = dp;
  
  bool gevaar = false;

  if (wandTemp < dp) // zum Testen
  {
    gevaar = true;
    Serial.println("!!! Schimmel gevaar");
  }

  return gevaar;
}

bool detectSchimmelGevaar(float dth22Temp, float dth22Humidity, float wandTemp)
{
  return calc(dth22Temp, dth22Humidity, wandTemp);
}

/*

  Dauwpunt berekening
  http://www.weerschip.nl/formules.html

  Td = 243.12 * A / (17.62 - A) grdC

  waarbij:
  A = Log(RH / 100) / Log(2.718282) + (17.62 * Ta / (243.12 + Ta))

  - A = een hulpvariabele voor berekening Td


  - Ta = omgevingtemperatuur in °C
  - PTa = de verzadigde dampdruk van de omgevingtemperatuur
  - Td = dauwpunttemperatuur in °C
  - PTd = de verzadigde dampdruk van de dauwpunttemperatuur
  - RH = relatieve vochtigheid in %

*/
