/*
 * Alle tijden zijn tov GMT tijden 0 uur UTC
 */
DateTime getTime()
{
  DateTime now = _rtc.now();

  // +1 uur ivm tijdzone
  now = now.unixtime() + (60 * 60);

  if (checkDTS())
  {
    // + 1 uur zomertijd
    now = now.unixtime() + (60 * 60);
  }

  return now;
}

void setTime(DateTime date)
{
  // -1 uur ivm tijdzone
  date = date.unixtime() - (60 * 60);

  // Zomer tijd dan nog 1 uur eraf
  if (checkDTS(date))
  {
    date = date.unixtime() - (60 * 60);
  }

  _rtc.adjust(date);
}

bool checkDTS()
{
  DateTime date = _rtc.now();
  //Serial.println("rtc tijd");

  checkDTS(date);
}

bool checkDTS(DateTime date)
{
  // +1 uur ivm tijdzone
  date = date.unixtime() + (60 * 60);

  DateTime st = findLastSunday(date.year(), 3);
  DateTime et = findLastSunday(date.year(), 10);

  bool summerTime  = (date.unixtime() >= st.unixtime() && date.unixtime() <= et.unixtime());

  return summerTime;
}

DateTime findLastSunday(int year, int month)
{
  // Summer wintertime is at 2:00 AM
  DateTime dt (year, month, 31, 2, 0, 0);

  // find first sunday 1 day = 60*60*24 = 86400
  int dow = dt.dayOfTheWeek();
  while (dow != 0)
  {
    dt = dt.unixtime() - 86400;
    dow = dt.dayOfTheWeek();
  }

  return dt;
}

void getSummerTimePeriode(int year, DateTime* datum)
{
  DateTime st = findLastSunday(year, 3);
  DateTime et = findLastSunday(year, 10);

  datum[0] = st;
  datum[1] = et;
}

