bool syncTimeWithServer()
{
  int teller = 0;
  bool syncOk = false;
  String msg = "Sync Failed";

  bool wifiOk = turnOnWiFi();
  delay(1000);  //esp takes a while to restart 5000 ms

  if (wifiOk)
  {
    while (teller < 3 && !syncOk)
    {
      syncOk = syncTime();

      if (syncOk)
      {
        msg = "Sync OK";
        teller = 10;
      }
      else
      {
        teller ++;
      }

      Serial.println(teller);
    }

    Serial.println(msg);

  }

  return syncOk;

}

bool syncTime()
{
  bool sync = false;

  String cmd = "AT+CIPSTART=\"TCP\",\"";  //make this command: AT+CPISTART="TCP","146.227.57.195",80
  cmd += "192.168.10.1";
  cmd += "\",80";

  Serial2.println(cmd);  //send command to device

  delay(500);  //2000 wait a little while for 'Linked' response - this makes a difference
  if (Serial2.find("Linked")) //message returned when connection established WEAK SPOT!! DOESN'T ALWAYS CONNECT
  {
    //    Serial.print("Connected to server at ");  //debug message
    //    Serial.println(DST_IP_time);
  }
  else
  {
    //    Serial.println("'Linked' response not received");  //weak spot! Need to recover elegantly
  }

  //  Serial.println("3");

  cmd = "GET /getdatetime.php HTTP/1.1\r\nHost: 192.168.10.1\r\n\r\n";

  Serial2.print("AT+CIPSEND=");
  Serial2.println(cmd.length());  //esp8266 needs to know message length of incoming message - .length provides this

  delay(500); //1000

  //  Serial.println("4");

  if (Serial2.find(">"))   //prompt offered by esp8266
  {
    // Serial.println("found > prompt - issuing GET request");  //a debug message
    Serial2.println(cmd);  //this is our http GET request
  }
  else
  {
    Serial2.println("AT+CIPCLOSE");  //doesn't seem to work here?
    Serial.println("No '>' prompt received after AT+CPISEND");
  }

  //  Serial.println("5");

  if (Serial2.find("@"))   //prompt offered by esp8266
  {

    int jaar = Serial2.parseInt();
    int maand = Serial2.parseInt();
    int dag = Serial2.parseInt();
    int uur = Serial2.parseInt();
    int minute = Serial2.parseInt();
    int seconde = Serial2.parseInt();

    Serial2.flush();

    /*
            Serial.println("--------------->>");
            Serial.println(dag);
            Serial.println(maand);
            Serial.println(jaar);
            Serial.println(uur);
            Serial.println(minute);
            Serial.println(seconde);
            Serial.println("--------------->>");
    */

    DateTime dt (jaar, maand, dag, uur, minute, seconde);

    _rtc.adjust(dt);

    sync = true;

    /* rekenen met tijden

            DateTime dt7 (dt6.unixtime() + 3600); // one hour later
        showDate("dt7", dt7);

        DateTime dt8 (dt6.unixtime() + 86400L); // one day later
        showDate("dt8", dt8);

        DateTime dt9 (dt6.unixtime() + 7 * 86400L); // one week later
        showDate("dt9", dt9);
    */
  }

  //  Serial.println("Close internet time");

  Serial2.println("AT+CIPCLOSE");

  if (Serial2.find("Unlink")) //rarely seems to find Unlink? :(
  {
    Serial.println("Connection Closed Ok...");
  }
  else
  {
    //Serial.println("connection close failure");
  }

  return sync;
}




