/*
  Arduino Water flow meter
  YF- S201 Hall Effect Water Flow Sensor
  result:
  litres/hour
  total litres

  Pin Connections:
  Zwart    GND
  Rood     + 5V
  Groen    Pin 2 (interupt pin)

  1 liter = 450 square waves

  7,5 = 450 / 60 [L / min]
  Pulse frequency (Hz) = 7.5Q, Q is flow rate in L/min.
  L/hour = (Pulse frequency x 60 min) / 7.5Q
*/

#include <LiquidCrystal.h>
LiquidCrystal lcd(12, 11, 10, 9, 8, 7);

//   Na calliberen is er een correctie factor van 1,1333 uitgekomen
double const correctieFactor = 1.1333;


volatile int flow_frequency; // Measures flow sensor pulses
unsigned int l_hour; // Calculated litres/hour
unsigned char flowsensor = 2; // Sensor Input
unsigned long currentTime;
unsigned long cloopTime;

volatile double waterFlow;

void flow () // Interrupt function
{
  flow_frequency++;
  waterFlow += 1.0 / 450.0;
}

void setup()
{
  lcd.begin(16, 2);
  lcd.setCursor(0, 0);
  lcd.print(" Water  verbuik");

  pinMode(flowsensor, INPUT);
  digitalWrite(flowsensor, HIGH); // Optional Internal Pull-Up
  Serial.begin(9600);

  attachInterrupt(0, flow, RISING); // Setup Interrupt
  sei(); // Enable interrupts
  currentTime = millis();
  cloopTime = currentTime;

  waterFlow = 0;
}

void loop ()
{
  currentTime = millis();
  // Every second, calculate and print litres/hour
  if (currentTime >= (cloopTime + 1000))
  {
    cloopTime = currentTime; // Updates cloopTime
    l_hour = (flow_frequency * 60 / 7.5) * correctieFactor;
    flow_frequency = 0; // Reset Counter
    Serial.print(l_hour, DEC);
    Serial.println(" L/hour");

    // Correctie
    double waterFlowCorrectie = waterFlow * correctieFactor;

    Serial.print("waterFlow:");
    Serial.print(waterFlowCorrectie);
    Serial.println("   L");

    lcd.setCursor(0, 1);
    lcd.print(waterFlowCorrectie);
    lcd.setCursor(5, 1);
    lcd.print("l");

    lcd.setCursor(9, 1);
    lcd.print(l_hour);
    lcd.setCursor(13, 1);
    lcd.print("l/u");
  }
}

