// Date and time functions using a DS1307 RTC connected via I2C and Wire lib

#include <Wire.h>
#include "RTClib.h"
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd1(0x26, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);
LiquidCrystal_I2C lcd2(0x27, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);

#include <Adafruit_SSD1306.h>
Adafruit_SSD1306 display(4);

RTC_DS1307 rtc;

char daysOfTheWeek[7][12] = {"zo", "ma", "di", "wo", "do", "vr", "za"};
String title = " ** Arduino watch **";

void setup () {
  Serial.begin(9600);

  lcd1.begin(20, 4);
  lcd1.clear();
  lcd1.setCursor(0, 0);
  lcd1.print(title);
  lcd1.backlight();

  lcd2.begin(20, 4);
  lcd2.clear();
  lcd2.setCursor(0, 0);
  lcd2.print(title);
  lcd2.backlight();

  display.begin(SSD1306_SWITCHCAPVCC);
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);
  display.print(title);
  display.display();

  if (! rtc.begin()) {
    Serial.println("Couldn't find RTC");
    while (1);
  }

  if (! rtc.isrunning()) {
    Serial.println("RTC is NOT running!");
    // following line sets the RTC to the date & time this sketch was compiled
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
    // This line sets the RTC with an explicit date & time, for example to set
    // January 21, 2014 at 3am you would call:
    // rtc.adjust(DateTime(2014, 1, 21, 3, 0, 0));
  }

  rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
}

void loop () {

  DateTime now = rtc.now();
  display.setTextSize(1);
  display.setTextColor(WHITE);

  // Time on Ole display
  display.setCursor(0, 10);
  clean("               ");
  display.setCursor(0, 10);
  display.print("Tijd : ");
  displayTimeOle(now);

  // Date on Ole display
  display.setCursor(0, 20);
  clean("                    ");
  display.setCursor(0, 20);
  display.print("Datum: ");
  displayDateOle(now);

  // Reverse big time on Ole display
  display.setTextSize(2);
  display.setTextColor(BLACK, WHITE);
  display.setCursor(15, 40);
  clean("        ");
  display.setCursor(15, 40);
  display.setTextColor(BLACK, WHITE);
  displayTimeOle(now);

  // Show it on Ole displays
  display.display();

  // Time on LCD display
  lcd1.setCursor(0, 1);
  lcd1.print("Tijd : ");
  displayTimeLCD1(now);

  // Time on LCD display
  lcd2.setCursor(0, 1);
  lcd2.print("Tijd : ");
  displayTimeLCD2(now);

  // Date on LCD display
  lcd1.setCursor(0, 2);
  lcd1.print("Datum: ");
  displayDateLCD1(now);

  lcd2.setCursor(0, 2);
  lcd2.print("Datum: ");
  displayDateLCD2(now);

  delay(100);
}

void displayDateLCD1(DateTime now)
{
  lcd1.print(displayNumber(now.day()));
  lcd1.print('-');
  lcd1.print(displayNumber(now.month()));
  lcd1.print('-');
  lcd1.print(now.year(), DEC);
  lcd1.print(" ");
  lcd1.print(daysOfTheWeek[now.dayOfTheWeek()]);
}

void displayDateLCD2(DateTime now)
{
  lcd2.print(displayNumber(now.day()));
  lcd2.print('-');
  lcd2.print(displayNumber(now.month()));
  lcd2.print('-');
  lcd2.print(now.year(), DEC);
  lcd2.print(" ");
  lcd2.print(daysOfTheWeek[now.dayOfTheWeek()]);
}

void displayTimeLCD1(DateTime now)
{
  lcd1.print(displayNumber(now.hour()));
  lcd1.print(':');
  lcd1.print(displayNumber(now.minute()));
  lcd1.print(':');
  lcd1.print(displayNumber(now.second()));
}

void displayTimeLCD2(DateTime now)
{
  lcd2.print(displayNumber(now.hour()));
  lcd2.print(':');
  lcd2.print(displayNumber(now.minute()));
  lcd2.print(':');
  lcd2.print(displayNumber(now.second()));
}

void displayDateOle(DateTime now)
{
  display.print(displayNumber(now.day()));
  display.print('-');
  display.print(displayNumber(now.month()));
  display.print('-');
  display.print(now.year(), DEC);
  display.print(" ");
  display.print(daysOfTheWeek[now.dayOfTheWeek()]);
}

void displayTimeOle(DateTime now)
{
  display.print(displayNumber(now.hour()));
  display.print(':');
  display.print(displayNumber(now.minute()));
  display.print(':');
  display.print(displayNumber(now.second()));
}

void clean(String waarde)
{
  int len = waarde.length();
  String cr = "";

  for (int t = 0; t < len; t++)
  {
    cr += " ";
  }

  display.setTextColor(BLACK, WHITE); // 'inverted' text
  display.print(cr);
  display.setTextColor(WHITE, BLACK);
}

String displayNumber(int number)
{
  String numberOut = "";

  if (number < 10)
  {
    numberOut += "0";
  }

  numberOut += number;

  return numberOut;
}
