/*
    MIT License

    Copyright (c) 2018, Alexey Dynda

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
*/

#include "ssd1306.h"
#include "levels.h"

const uint8_t blockColors[]=
{
    0,
    RGB_COLOR8(128,128,128), // Grey       1
    RGB_COLOR8(255,64,64),   // Red        2
    RGB_COLOR8(255,255,64),  // Yellow     3
    RGB_COLOR8(64,64,255),   // Blue       4
    RGB_COLOR8(255,64,255),  // Cyan       5
    RGB_COLOR8(64,255,64),   // Green      6
    RGB_COLOR8(255,255,255), // White      7
    RGB_COLOR8(255,192,64),  // Orange     8
    RGB_COLOR8(128,255,192), // Light-blue 9
};


const PROGMEM uint8_t bgTile[] =
{
     0B00000001,
     0B11000010,
     0B00101100,
     0B00010000,
     0B00101100,
     0B01000010,
     0B10000001,
     0B00000001,
};

const PROGMEM uint8_t levels[MAX_LEVELS][BLOCK_NUM_ROWS][MAX_BLOCKS_PER_ROW] =
{
    {   // LEVEL 1
        { 1,1,1,1,1,1,1,1, },
        { 2,2,2,2,2,2,2,2, },
        { 3,3,3,3,3,3,3,3, },
        { 4,4,4,4,4,4,4,4, },
        { 5,5,5,5,5,5,5,5, },
    },
    {   // LEVEL 2
        { 7,8,0,0,0,0,0,0, },
        { 7,8,9,6,0,0,0,0, },
        { 7,8,9,6,1,4,0,0, },
        { 7,8,9,6,1,4,5,3, },
        { 1,1,1,1,1,1,1,2, },
    },
    {   // LEVEL 3
        { 0,0,1,1,1,1,0,0, },
        { 0,1,2,1,1,2,1,0, },
        { 1,1,1,1,1,1,1,1, },
        { 1,0,1,1,1,1,0,1, },
        { 0,0,1,0,0,1,0,0, },
    },
};

