#include <Adafruit_NeoPixel.h>

#define PIN1           5
#define PIN2           6
#define NUMPIXELS      3
Adafruit_NeoPixel trafficLight1 = Adafruit_NeoPixel(NUMPIXELS, PIN1, NEO_GRB + NEO_KHZ800);
Adafruit_NeoPixel trafficLight2 = Adafruit_NeoPixel(NUMPIXELS, PIN2, NEO_GRB + NEO_KHZ800);

#define rood   2
#define oranje 1
#define groen  0

#define brightness  50

void setup() {
  Serial.begin(9600);

  trafficLight1.begin();
  trafficLight1.setBrightness(brightness);
  trafficLight2.begin();
  trafficLight2.setBrightness(brightness);

  ResetTraficLight(trafficLight1);
  ResetTraficLight(trafficLight2);

  TraficLightOutOfOrder(15);
}

void loop() {
  for (int i = 0; i < 2; i++)
  {
    TraficLightSingleLoop();
  }

  TraficLightOutOfOrder(15);
}

void TraficLightOutOfOrder(int delaySeconds)
{
  SetTraficLight(trafficLight1, rood);
  SetTraficLight(trafficLight2, rood);
  delay(3000);

  SetTraficLightBlink(trafficLight1, trafficLight2, delaySeconds);

  SetTraficLight(trafficLight1, rood);
  SetTraficLight(trafficLight2, rood);
  delay(3000);
}

void TraficLightSingleLoop()
{
  SetTraficLight(trafficLight2, rood);
  delay(500);
  
  SetTraficLight(trafficLight1, groen);
  delay(5000);

  SetTraficLight(trafficLight1, oranje);
  delay(1000);

  SetTraficLight(trafficLight1, rood);
  delay(500);
  
  SetTraficLight(trafficLight2, groen);
  delay(5000);

  SetTraficLight(trafficLight2, oranje);
  delay(1000);
}

void SetTraficLightBlink(Adafruit_NeoPixel &traficLight1, Adafruit_NeoPixel &traficLight2, int delaySeconds)
{
  uint32_t timer = millis();

  do
  {
    SetTraficLight(trafficLight1, oranje);
    SetTraficLight(trafficLight2, oranje);
    delay(500);
    ResetTraficLight(trafficLight1);
    ResetTraficLight(trafficLight2);
    delay(500);

  } while (timer + (delaySeconds * 1000) >= millis());
}

void SetTraficLight(Adafruit_NeoPixel &traficLight, int lightNumber)
{
  uint32_t color;

  switch (lightNumber)
  {
    case groen:
      Serial.println("Groen");
      color = traficLight.Color(0, 255, 0);
      break;

    case oranje:
      Serial.println("Oranje");
      color = traficLight.Color(253, 106, 2);
      break;

    case rood:
      Serial.println("Rood");
      color = traficLight.Color(255, 0, 0);
      break;
  }

  ResetTraficLight(traficLight);
  traficLight.setPixelColor(lightNumber, color);
  traficLight.show();
}

void ResetTraficLight(Adafruit_NeoPixel &pixels)
{
  uint32_t colorOff = pixels.Color(0, 0, 0);

  pixels.setPixelColor(rood, colorOff);
  pixels.setPixelColor(groen, colorOff);
  pixels.setPixelColor(oranje, colorOff);
  pixels.show();
}
