// Het programma is getest met een Arduino Nano

#include <SoftwareSerial.h>
#include <elapsedMillis.h>
elapsedMillis timeElapsed;

// Definieer data transmit/receive pins Arduino
#define TxD 2
#define RxD 3
#define KlepPin 13

SoftwareSerial mySerial(RxD, TxD); // RX, TX Bluetooth

unsigned long interval = 20 * 60000; // minuten * 60 * 1000 klep actief

bool timerActive = false;

void setup() {

  pinMode(KlepPin, OUTPUT);

  mySerial.begin(9600); // Bluetooth
  Serial.begin(9600);   // IDE monitor
}

void loop() {

  // put your main code here, to run repeatedly:
  boolean isValidInput;

  do {
    byte c; // get the next character from the bluetooth serial port

    while ( !mySerial.available() )
    {
      if (timerActive)
      {
        if (timeElapsed > interval)
        {
          digitalWrite(KlepPin, LOW);
          timeElapsed = 0;              // reset the counter to 0 so the counting starts over...
          timerActive = false;
        }
      }
    }

    c = mySerial.read(); // Execute the option based on the character recieved

    Serial.print(c); // Print the character received to the IDE serial monitor

    switch ( c ) {

      case '0': // Klep dicht
        mySerial.println( "You've entered an '0'" );
        digitalWrite(KlepPin, LOW);

        timerActive = false;
        isValidInput = true;
        break;

      case '1': // Klep open
        mySerial.println( "You've entered an '1'" );
        digitalWrite(KlepPin, HIGH);

        timerActive = false;
        isValidInput = true;
        break;

      case 'W': // Klep open voor 'interval' var aantal seconden

        mySerial.println( "You've entered an 'W'" );
        digitalWrite(KlepPin, HIGH);

        timerActive = true;
        timeElapsed = 0;              // reset the counter to 0 so the counting starts over...
        isValidInput = true;
        break;

      default:
        mySerial.println( "Please enter '0', '1' or 'W'" );
        isValidInput = false;
        break;
    }
  } while ( isValidInput == true );
}

