#include <Wire.h> //BH1750 IIC Mode
#include <math.h>

int BH1750_Device = 0x23; // I2C address for light sensor; ADDR high --> 0x5C
unsigned int Lux, Scaled_FtCd;
float FtCd, Wattsm2;

void setup() {
  Wire.begin();
  Serial.begin(9600);

  Wire.beginTransmission(BH1750_Device);
  Wire.write(0x10); // Set resolution to 1 Lux
  Wire.endTransmission();

  delay(200);
}

void loop() {
  int i;
  Lux = BH1750_Read();
  FtCd = Lux/10.764;
  Wattsm2 = Lux/683.0;
  Serial.print(Lux,DEC);     
  Serial.println("[lx]"); 
  Serial.print(FtCd,2);     
  Serial.println("[FC]");
  Serial.print(Wattsm2,4);     
  Serial.println("[Watts/m^2]"); 
  delay(1000);
}

unsigned int BH1750_Read() {
  unsigned int i=0;
  Wire.beginTransmission(BH1750_Device);
  Wire.requestFrom(BH1750_Device, 2);
  while(Wire.available()) //
  {
    i <<=8;
    i|= Wire.read();  
  }
  Wire.endTransmission();  
  return i/1.2;  // Convert to Lux
}
