#include <SPI.h>        //SPI.h must be included as DMD is written by SPI (the IDE complains otherwise)
#include <DMD419.h>
#include <TimerOne.h>
#define DISPLAYS_ACROSS 2
#define DISPLAYS_DOWN 1
DMD419 dmd(DISPLAYS_ACROSS, DISPLAYS_DOWN);

const int sampleWindow = 50; // Sample window width in mS (50 mS = 20Hz)
unsigned int sample;

int ledX = 0;
int ledY = 0;

void setup()
{
  Serial.begin(9600);
  InitDMD();
}

void InitDMD()
{
  Timer1.initialize( 5000 );           //period in microseconds to call ScanDMD. Anything longer than 5000 (5ms) and you can see flicker.
  Timer1.attachInterrupt( ScanDMD );   //attach the Timer1 interrupt to ScanDMD which goes to dmd.scanDisplayBySPI()

  //clear/init the DMD pixels held in RAM
  dmd.clearScreen( true );   //true is normal (all pixels off), false is negative (all pixels on)
}

void ScanDMD()
{
  dmd.scanDisplayBySPI();
}

void loop()
{
  unsigned long startMillis = millis(); // Start of sample window
  unsigned int peakToPeak = 0;   // peak-to-peak level

  unsigned int signalMax = 0;
  unsigned int signalMin = 1024;

  // collect data for 50 mS
  while (millis() - startMillis < sampleWindow)
  {
    sample = analogRead(0);
    if (sample < 1024)  // toss out spurious readings
    {
      if (sample > signalMax)
      {
        signalMax = sample;  // save just the max levels
      }
      else if (sample < signalMin)
      {
        signalMin = sample;  // save just the min levels
      }
    }
  }
  peakToPeak = signalMax - signalMin;  // max - min = peak-peak amplitude
  //  double volts = (peakToPeak * 5.0) / 1024;  // convert to volts

  // Convert to LED matrix hight (is 16 LEDS)
  ledY = (16 * peakToPeak / 725);

  clearColumn(ledX);
  if (ledY > 0)
  {
    dmd.drawLine(ledX, 15, ledX, (15 - ledY), GRAPHICS_NORMAL);
  }

  ledX ++;
  if (ledX >= 64)
  {
    ledX = 0;
  }
}

// clear the actual column
void clearColumn(int columnNumber)
{
  for (int y = 0; y <= 15; y++)
  {
    dmd.writePixel(columnNumber, y, GRAPHICS_NORMAL, false);
  }
}
