/* DOPPLER RADAR TEST CODE
*************************************
  Gebruikt een Arduino Nano
  met 2 sensoren
*/
byte sense_1 = 0;
byte sense_2 = 0;

const int8_t Output_1 = 4;
const int8_t Output_2 = 5;
const int8_t sensor_1 = 2;
const int8_t sensor_2 = 3;

void setup() {
  Serial.begin(9600);
  
#ifdef ESP8266
  Serial.println(" 14CORE | DOPPLER RADAR TEST CODE");
  Serial.println("==================================");
  Serial.println("ESP8266 Started......");

  digitalWrite(Output_1, HIGH);
  digitalWrite(Output_2, HIGH);

#else
  Serial.println("Arduino MCU Started......");
  digitalWrite(Output_1, LOW);
  digitalWrite(Output_2, LOW);
#endif
  
  pinMode(Output_1, OUTPUT);
  pinMode(Output_2, OUTPUT);

  pinMode(sensor_1, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(sensor_1), moving_sensor_1, CHANGE);

  pinMode(sensor_2, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(sensor_2), moving_sensor_2, CHANGE);
}

void loop() {
  delay(1000);
  Serial.println("");
}

void moving_sensor_1()
{
  sense_1 = digitalRead(sensor_1);

  Serial.println("Raw Value sensor 1: ");
  Serial.print(sensor_1);
  Serial.println(sense_1 ? "+HIGH" : "-LOW");
  Serial.println(sense_1);

  digitalWrite(Output_1, sense_1);
}

void moving_sensor_2()
{
  sense_2 = digitalRead(sensor_2);

  Serial.println("Raw Value sensor 2: ");
  Serial.print(sensor_2);
  Serial.println(sense_2 ? "+HIGH" : "-LOW");
  Serial.println(sense_2);

  digitalWrite(Output_2, sense_2);
}
