/* Code by Maddy McGee
 * Updated 7/2/18
 * https://www.hackster.io/Maddy
 * 
 * A runthrough and demonstation of matrix methods for the DFRobot RGB Matrix library
 */
#include <DFRobot_RGBMatrix.h> // Hardware-specific library

/* Below is the pin definition
 * These pins can be swapped as long as the code is changed to reflect such change.
 * The pins must also support the same capabilities (i.e. DIO vs PWM)
 * Other pins are set in the library and need to follow the wiring schematic provided.
 */
#define OE    9
#define LAT   10
#define CLK   11
#define A     A0
#define B     A1
#define C     A2
#define D     A3
#define E     A4
#define WIDTH 64 // # of LEDs vertically
#define HEIGHT  64 // # of LEDs horizontally

DFRobot_RGBMatrix matrix(A, B, C, D, E, CLK, LAT, OE, false, WIDTH, HEIGHT);

//Colors on the screen are created in RGB with each color an integer ranging from 0 to 7
int r = 7;
int g = 7;
int b = 7;

//The coordinate system for the matrix are integers with (0,0) being the upper leftmost corner
// 1 = one LED, so (5, 10) is five LEDs to the right and 10 LEDs down
int x = 5;
int y = 10;
int x2 = 27;
int y2 = 32;

int wide = 40;
int high = 17;
int radius = 4;

void setup() {
  matrix.begin();//This line must come before modifying the matrix screen

  //This is the format for creating a color
  //A color can be int or uint16_t
  int white = matrix.Color333(r, g, b);
  uint16_t black = matrix.Color333(0, 0, 0);
  int darkRed = matrix.Color333(1, 0, 0);
  uint16_t brightRed = matrix.Color333(7, 0, 0);
  int green = matrix.Color333(0, 7, 0);
  int blue = matrix.Color333(0, 0, 7);
  int magenta = matrix.Color333(7, 0, 7);
  int cyan = matrix.Color333(0, 7, 7);
  int yellow = matrix.Color333(7, 7, 0);

  //Fills the screen one color
  matrix.fillScreen(darkRed);

  //Set a single LED to one color
  //This puts the pixel in the lower right corner
  matrix.drawPixel(WIDTH - 1, HEIGHT - 1, white);

  //Draw and fill a box, the (x,y) coordinates are the upper left corner
  matrix.fillRect(x, y, wide, high, brightRed);

  //You can notice each element stacks based on order of method call
  delay(1000);
  
  //Draw the perimeter of a box, the (x,y) coordinates are the upper left corner
  matrix.drawRect(x, y, wide, high, black);

  //Without delays each element can appear to be drawn simultaneously
  //But if you introduce simulated movement screen refreshing becomes noticeable
  delay(500);
  
  //Draw and fill a circle with the (x,y) coordinate at the center
  matrix.drawCircle(x,y,radius,yellow);
  //Draw the perimeter of a circle with the (x,y) coordinate at the center
  matrix.fillCircle(x2,y2,radius,cyan);

  //Draw a line from one point to another
  matrix.drawLine(x,y,x2,y2,green);

  //Text can be printed to the matrix
  //When drawn text starts in the upper left corner by default
  //If the cursor position is set that will be the upper left of the text
  //Text color can be set 
  //Text size can be set with size * 8 = height of text, size 1 = 8 LEDs, size 2 = 16 LEDs, etc
  matrix.setTextColor(blue);
  matrix.print("Blue");
  matrix.setTextColor(magenta);
  matrix.setTextSize(2);
  matrix.setCursor(x2,y2);
  matrix.println("Not blue");
  
  
}

void loop() {

}
