#include <Wire.h>
#include "paj7620.h"

int smDirectionPin = 4; //Direction pin
int smStepPin = 3; //Stepper pin
int rnd360 = 800;

/*
  Notice: When you want to recognize the Forward/Backward gestures, your gestures' reaction time must less than GES_ENTRY_TIME(0.8s).
        You also can adjust the reaction time according to the actual circumstance.
*/
#define GES_REACTION_TIME   500       // You can adjust the reaction time according to the actual circumstance.
#define GES_ENTRY_TIME      800       // When you want to recognize the Forward/Backward gestures, your gestures' reaction time must less than GES_ENTRY_TIME(0.8s). 
#define GES_QUIT_TIME     1000

void setup()
{
  pinMode(smDirectionPin, OUTPUT);
  pinMode(smStepPin, OUTPUT);

  uint8_t error = 0;

  Serial.begin(9600);
  Serial.println("\nPAJ7620U2 TEST DEMO: Recognize 9 gestures.");

  error = paj7620Init();      // initialize Paj7620 registers
  if (error)
  {
    Serial.print("INIT ERROR,CODE:");
    Serial.println(error);
  }
  else
  {
    Serial.println("INIT OK");
  }
  Serial.println("Please input your gestures:\n");
}

void loop()
{
  uint8_t data = 0, data1 = 0, error;

  error = paj7620ReadReg(0x43, 1, &data);       // Read Bank_0_Reg_0x43/0x44 for gesture result.
  if (!error)
  {
    switch (data)                   // When different gestures be detected, the variable 'data' will be set to different values by paj7620ReadReg(0x43, 1, &data).
    {
      case GES_CLOCKWISE_FLAG:
        Serial.println("Clockwise");
        TurnMoter(HIGH);
        break;
      case GES_COUNT_CLOCKWISE_FLAG:
        Serial.println("anti-clockwise");
        TurnMoter(LOW);
        break;
      default:
        break;
    }
  }
  delay(100);
}

void TurnMoter(byte clockwise)
{
  digitalWrite(smDirectionPin, clockwise); //Writes the direction to the EasyDriver DIR pin. (HIGH is clockwise).

  /*Slowly turns the motor 1600 steps*/
  for (int i = 0; i < rnd360; i++) {
    digitalWrite(smStepPin, HIGH);
    delayMicroseconds(1000);
    digitalWrite(smStepPin, LOW);
    delayMicroseconds(1000);
  }
}

void TurnMoterTo(byte clockwise)
{
  digitalWrite(smDirectionPin, clockwise); //Writes the direction to the EasyDriver DIR pin. (HIGH is clockwise).

  /*Slowly turns the motor 1600 steps*/
  for (int i = 0; i < (rnd360 / 4); i++) {
    digitalWrite(smStepPin, HIGH);
    delayMicroseconds(1000);
    digitalWrite(smStepPin, LOW);
    delayMicroseconds(1000);
  }

  delay(2000);
  digitalWrite(smDirectionPin, !clockwise); //Writes the direction to the EasyDriver DIR pin. (HIGH is clockwise).

  /*Slowly turns the motor 1600 steps*/
  for (int i = 0; i < (rnd360 / 4); i++) {
    digitalWrite(smStepPin, HIGH);
    delayMicroseconds(1000);
    digitalWrite(smStepPin, LOW);
    delayMicroseconds(1000);
  }
}
