#define ledGroen 6
#define ledGeel 5
#define ledRood 4
#define potX A0
#define potY A1
#define switch 7

void setup() {
  pinMode(A0, INPUT);
  pinMode(A1, INPUT);
  pinMode(switch, INPUT_PULLUP); 

  pinMode(ledGroen, OUTPUT);
  pinMode(ledGeel, OUTPUT);
  pinMode(ledRood, OUTPUT);

  Serial.begin(9600);
}

void loop() {
  int valueX = analogRead(potX); // read X axis value [0..1023]
  analogWrite(ledGeel, valueX);
  Serial.print("X:");
  Serial.print(valueX, DEC);

  int valueY = analogRead(potY); // read Y axis value [0..1023]
  analogWrite(ledGroen, valueY);
  Serial.print(" | Y:");
  Serial.print(valueY, DEC);

  int valueB = digitalRead(switch); // read Button state [0,1]
  digitalWrite(ledRood, !valueB);
  Serial.print(" | Button:");
  Serial.println(valueB, DEC);

  delay(100);
}
