#define _FanLowPin 7
#define _FanMediumPin 8
#define _FanHighPin 9
#define _FanTimerPin 10
#define _FanPushTime 250

void setup()
{
pinMode(_FanLowPin, OUTPUT);
pinMode(_FanMediumPin, OUTPUT);
pinMode(_FanHighPin, OUTPUT);
pinMode(_FanTimerPin, OUTPUT);

// Medium button
executeIthoCmd("MED");

// Timer 20 minuten dat is normaal 2x drukken
executeIthoCmd("TMR20");

}

void loop()
{
}

void setFanTimer(int timeMinutes) {
  for (int t = 0; t < (timeMinutes / 10); t++) {
    digitalWrite(_FanTimerPin, HIGH);
    delay(_FanPushTime);
    digitalWrite(_FanTimerPin, LOW);
    delay(_FanPushTime);
  }
}

String executeIthoCmd(String code)
{
String response = "";
int timerValue = 0;

if (code == "PAIR")
{
digitalWrite(_FanLowPin, HIGH);
digitalWrite(_FanHighPin, HIGH);
delay(_FanPushTime * 2);
digitalWrite(_FanLowPin, LOW);
digitalWrite(_FanHighPin, LOW);
response = "fan pairing";
}
if (code == "UNPAIR")
{
digitalWrite(_FanLowPin, HIGH);
digitalWrite(_FanHighPin, HIGH);
digitalWrite(_FanMediumPin, HIGH);
digitalWrite(_FanTimerPin, HIGH);
delay(_FanPushTime * 2);
digitalWrite(_FanLowPin, LOW);
digitalWrite(_FanHighPin, LOW);
digitalWrite(_FanMediumPin, LOW);
digitalWrite(_FanTimerPin, LOW);
response = "fan unpairing";
}
if (code == "LOW")
{
digitalWrite(_FanLowPin, HIGH);
delay(_FanPushTime);
digitalWrite(_FanLowPin, LOW);
response = "fan low";
}
if (code == "MED")
{
digitalWrite(_FanMediumPin, HIGH);
delay(_FanPushTime);
digitalWrite(_FanMediumPin, LOW);
response = "fan medium";
}
if (code == "HI")
{
digitalWrite(_FanHighPin, HIGH);
delay(_FanPushTime);
digitalWrite(_FanHighPin, LOW);
response = "fan hi";
}
if (code.substring(0, 3) == "TMR")
{
if (code.length() > 3)
{
timerValue = code.substring(3).toInt();
}
setFanTimer(timerValue);
response = "fan timer " + String(timerValue) + " min.";
}

return response;
}