/*

  Pinout:
  HYT 221 view from top (Should be the same for all members of the HYT family. Check the Datasheet though.)

     ________
    |        |
    |- ...  -|
    |- ...  -|
    |- ...  -|
    |- ...  -|
    |_|_|_|_||
      | | | |
      | | | |
      | | | |
     VDD|NC |
        |   |
       D0  GND

  Data moet via 10 K naar VDD
*/

#include "DHT.h"

#define DHTPIN 4     // what digital pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302), AM2321

// Initialize DHT sensor.
// Note that older versions of this library took an optional third parameter to
// tweak the timings for faster processors.  This parameter is no longer needed
// as the current DHT reading algorithm adjusts itself to work on faster procs.
DHT dht(DHTPIN, DHTTYPE);

void setupDHT22()
{
  Serial.begin(9600);
  Serial.println("DHTxx test!");

  dht.begin();
}

void loopDHT22()
{
  // Reading temperature or humidity takes about 250 milliseconds!
  // Sensor readings may also be up to 2 seconds 'old' (its a very slow sensor)
  float h = dht.readHumidity();
  // Read temperature as Celsius (the default)
  float t = dht.readTemperature();
  // Read temperature as Fahrenheit (isFahrenheit = true)
  float f = dht.readTemperature(true);

  // Check if any reads failed and exit early (to try again).
  if (isnan(h) || isnan(t) || isnan(f)) {
    Serial.println("Failed to read from DHT sensor!");
    return;
  }

  // Compute heat index in Fahrenheit (the default)
  float hif = dht.computeHeatIndex(f, h);
  // Compute heat index in Celsius (isFahreheit = false)
  float hic = dht.computeHeatIndex(t, h, false);

  myGLCD.setColor(VGA_GREEN);
  myGLCD.print("DHT22", 0, 200);

  myGLCD.setColor(VGA_SILVER);

  myGLCD.print("Vochtigheid:", 0, 210);
  myGLCD.printNumF(h , 2, 150, 210);
  myGLCD.print("%", 210, 210);

  myGLCD.print("Temperatuur:", 0 , 220);
  myGLCD.printNumF(t , 2, 150, 220);
  myGLCD.print("C", 210, 220);

  _DHT22Hyd = h;
  _DHT22Tmp = t;
}
