/**
   TCA9548 I2CScanner.pde -- I2C bus scanner for Arduino

   Based on code c. 2009, Tod E. Kurt, http://todbot.com/blog/

*/

#include "Wire.h"
#include "RTClib.h"
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);  // Set the LCD I2C address

RTC_DS1307 rtc1;
RTC_DS1307 rtc2;
RTC_DS1307 rtc3;

extern "C" {
#include "utility/twi.h"  // from Wire library, so we can do bus scanning
}

#define TCAADDR 0x70

bool initTime = false; // true betekend tijd instellen op de RTC's via de PC
int offset = 15; // ofset in seconden tov de tijd

void tcaselect(uint8_t i) {
  if (i > 7) return;

  Wire.beginTransmission(TCAADDR);
  Wire.write(1 << i);
  Wire.endTransmission();
}


// standard Arduino setup()
void setup()
{
  lcd.begin(20, 4);
  // clear the LCD screen:
  lcd.clear();

  lcd.setCursor(0, 0);
  lcd.print("   ** RTC test **");

  while (!Serial);
  delay(1000);

  Wire.begin();
  Serial.begin(9600);

  DateTime dt = DateTime(F(__DATE__), F(__TIME__));
  dt = dt + offset;
  
  Serial.print(dt.year(), DEC);
  Serial.print('/');
  Serial.print(dt.month(), DEC);
  Serial.print('/');
  Serial.print(dt.day(), DEC);
  Serial.print(" ");
  Serial.print(dt.hour(), DEC);
  Serial.print(':');
  Serial.print(dt.minute(), DEC);
  Serial.print(':');
  Serial.print(dt.second(), DEC);
  Serial.println();

  tcaselect(0);
  if (! rtc1.begin()) {
    lcd.setCursor(0, 1);
    lcd.print ("Couldn't find RTC 1");
    Serial.println("Couldn't find RTC");
    Serial.flush();
    abort();
  }
  if (! rtc1.isrunning()) {
    lcd.setCursor(0, 1);
    lcd.print ("RTC 1 is NOT running");
    Serial.println("RTC is NOT running, let's set the time!");

    // rtc1.adjust(DateTime(F(__DATE__), F(__TIME__)));
  }
  if (initTime)
  {
    rtc1.adjust(DateTime(dt.year(), dt.month(), dt.day(), dt.hour(), dt.minute(), dt.second()));
  }

  tcaselect(1);
  if (! rtc2.begin()) {
    lcd.setCursor(0, 2);
    lcd.print ("Couldn't find RTC 2");
    Serial.println("Couldn't find RTC");
    Serial.flush();
    abort();
  }
  if (! rtc2.isrunning()) {
    lcd.setCursor(0, 2);
    lcd.print ("RTC 2 is NOT running");
    Serial.println("RTC is NOT running, let's set the time!");

    // Unquote de ondestaande regel bij uploaden
    // Dan worden alle klokken gelijk gezet.
    // Upload daarna opnieuw, zonder onderstaande regel/
    // rtc2.adjust(DateTime(F(__DATE__), F(__TIME__)));
  }
  if (initTime)
  {
    rtc2.adjust(DateTime(dt.year(), dt.month(), dt.day(), dt.hour(), dt.minute(), dt.second()));
  }

  tcaselect(2);
  if (! rtc3.begin()) {
    lcd.setCursor(0, 3);
    lcd.print ("Couldn't find RTC 3");
    Serial.println("Couldn't find RTC");
    Serial.flush();
    abort();
  }
  if (! rtc3.isrunning()) {
    lcd.setCursor(0, 3);
    lcd.print ("RTC 3 is NOT running");
    Serial.println("RTC is NOT running, let's set the time!");

    // rtc3.adjust(DateTime(F(__DATE__), F(__TIME__)));
  }
  if (initTime)
  {
    rtc3.adjust(DateTime(dt.year(), dt.month(), dt.day(), dt.hour(), dt.minute(), dt.second()));
  }


  // ----------------------------------------------------------------------

  Serial.println("\nSetup klaar");
}

void loop()
{
  tcaselect(0);
  DateTime now1 = rtc1.now();
  tcaselect(1);
  DateTime now2 = rtc2.now();
  tcaselect(2);
  DateTime now3 = rtc3.now();

  Serial.print("RTC 1: ");
  Serial.print(now1.year(), DEC);
  Serial.print('/');
  Serial.print(now1.month(), DEC);
  Serial.print('/');
  Serial.print(now1.day(), DEC);
  Serial.print(" ");
  Serial.print(now1.hour(), DEC);
  Serial.print(':');
  Serial.print(now1.minute(), DEC);
  Serial.print(':');
  Serial.print(now1.second(), DEC);
  Serial.println();

  lcd.setCursor(0, 1);
  lcd.print ("RTC1 ");
  lcd.print (displayNummer(now1.year(), 4));
  lcd.print (displayNummer(now1.month(), 2));
  lcd.print (displayNummer(now1.day(), 2));
  lcd.print (" ");
  lcd.print (displayNummer(now1.hour(), 2));
  lcd.print (displayNummer(now1.minute(), 2));
  lcd.print (displayNummer(now1.second(), 2));


  Serial.print("RTC 2: ");
  Serial.print(now2.year(), DEC);
  Serial.print('/');
  Serial.print(now2.month(), DEC);
  Serial.print('/');
  Serial.print(now2.day(), DEC);
  Serial.print(" ");
  Serial.print(now2.hour(), DEC);
  Serial.print(':');
  Serial.print(now2.minute(), DEC);
  Serial.print(':');
  Serial.print(now2.second(), DEC);
  Serial.println();

  lcd.setCursor(0, 2);
  lcd.print ("RTC2 ");
  lcd.print (displayNummer(now2.year(), 4));
  lcd.print (displayNummer(now2.month(), 2));
  lcd.print (displayNummer(now2.day(), 2));
  lcd.print (" ");
  lcd.print (displayNummer(now2.hour(), 2));
  lcd.print (displayNummer(now2.minute(), 2));
  lcd.print (displayNummer(now2.second(), 2));



  Serial.print("RTC 3: ");
  Serial.print(now3.year(), DEC);
  Serial.print('/');
  Serial.print(now3.month(), DEC);
  Serial.print('/');
  Serial.print(now3.day(), DEC);
  Serial.print(" ");
  Serial.print(now3.hour(), DEC);
  Serial.print(':');
  Serial.print(now3.minute(), DEC);
  Serial.print(':');
  Serial.print(now3.second(), DEC);
  Serial.println();

  lcd.setCursor(0, 3);
  lcd.print ("RTC3 ");
  lcd.print (displayNummer(now3.year(), 4));
  lcd.print (displayNummer(now3.month(), 2));
  lcd.print (displayNummer(now3.day(), 2));
  lcd.print (" ");
  lcd.print (displayNummer(now3.hour(), 2));
  lcd.print (displayNummer(now3.minute(), 2));
  lcd.print (displayNummer(now3.second(), 2));



  Serial.println("\n");
  delay (1000);
}

String displayNummer(long nummer, int aantalCijfers)
{
  char buf[10];
  memset (buf, 0, sizeof(buf));
  snprintf(buf, sizeof(buf) - 1, "%d", nummer);

  String nummerTekst = buf;

  int lengte = nummerTekst.length();

  String nummerOut = "";
  for (int teller = 0; teller < aantalCijfers - lengte; teller++)
  {
    nummerOut += "0";
  }

  nummerOut += nummerTekst;
  nummerOut = nummerOut.substring(0, aantalCijfers);

  return nummerOut;
}
