#include <SoftwareSerial.h>
SoftwareSerial mySerial(11, 10); // RX, TX

// Relay --> NANO pin D2
#define Relay 2

void setup() {
  Serial.begin(9600);
  Serial.println("Start");

  pinMode(Relay, OUTPUT);

  // Reset het relay let op LOW is aan, HIGH is uit
  digitalWrite(Relay, HIGH);

  // BlueTooth
  mySerial.begin(9600);
}
void loop() {
  String ontvangenData;

  // Haal de data op van de BleuTooth module
  while (mySerial.available() > 0) {
    String commando = mySerial.readString();

    byte modeOutput; // LOW of HIGH
    int relayNummer = commando.substring(0, 1).toInt();

    // Bepaal of de schakelaar aan of uit moet
    // Let op LOW is aan, HIGH is uit
    if (commando.substring(1) == "aan")
    {
      Serial.println("Relay aan");
      modeOutput = LOW;
    }
    else
    {
      Serial.println("Relay uit");
      modeOutput = HIGH;
    }
    // Zet het relay in de juiste positie
    digitalWrite(Relay, modeOutput);
  }
}
