#include <GUVA-S12SD.h>
GUVAS12SD uv(A0);

#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);  // Set the LCD I2C address

void setup()
{
  // Nothing TODO
  Serial.begin(9600);

  lcd.begin(20, 4);
  lcd.clear();

  lcd.setCursor(2, 0);
  lcd.print("UV meter");
}

void loop()
{
  float mV = uv.read();
  float uv_index = uv.index(mV);
  Serial.println(uv_index);

  lcd.setCursor(12, 0);

  String msg = "UV: " + String(uv_index, 0) + "    ";
  lcd.print(msg);

  lcd.setCursor(0, 2);
  lcd.print("Na x min.:");
  lcd.setCursor(0, 3);
  lcd.print("Verbrand:");

  if (uv_index <= 2 )
  {
    lcd.setCursor(0, 1);
    lcd.print("Vrijwel geen");
    lcd.setCursor(11, 2);
    lcd.print("100 - 50");
    lcd.setCursor(10, 3);
    lcd.print("  Niet     ");
  }
  if (uv_index == 3 || uv_index == 4)
  {
    lcd.setCursor(0, 1);
    lcd.print("Zwak        ");
    lcd.setCursor(11, 2);
    lcd.print("35 - 25 ");
    lcd.setCursor(10, 3);
    lcd.print("  Niet     ");
  }
  if (uv_index == 5 || uv_index == 6)
  {
    lcd.setCursor(0, 1);
    lcd.print("Matig       ");
    lcd.setCursor(11, 2);
    lcd.print("25 - 15 ");
    lcd.setCursor(10, 3);
    lcd.print("Gemakkelijk");
  }
  if (uv_index == 7 || uv_index == 8)
  {
    lcd.setCursor(0, 1);
    lcd.print("Sterk       ");
    lcd.setCursor(11, 2);
    lcd.print("15 - 100");
    lcd.setCursor(10, 3);
    lcd.print("Snel       ");
  }
  if (uv_index > 8 )
  {
    lcd.setCursor(0, 1);
    lcd.print("Zeer sterk  ");
    lcd.setCursor(11, 2);
    lcd.print("<10     ");
    lcd.setCursor(10, 3);
    lcd.print("Zeer snel  ");
  }
}
