#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
#include <avr/power.h>
#endif

#define PIN 6


Adafruit_NeoPixel strip = Adafruit_NeoPixel(8, PIN, NEO_GRB + NEO_KHZ800);

// IMPORTANT: To reduce NeoPixel burnout risk, add 1000 uF capacitor across
// pixel power leads, add 300 - 500 Ohm resistor on first pixel's data input
// and minimize distance between Arduino and first pixel.  Avoid connecting
// on a live circuit...if you must, connect GND first.

#define stomer1 2
#define stomer2 3

void setup() {
  // This is for Trinket 5V 16MHz, you can remove these three lines if you are not using a Trinket
#if defined (__AVR_ATtiny85__)
  if (F_CPU == 16000000) clock_prescale_set(clock_div_1);
#endif
  // End of trinket special code

  strip.begin();
  strip.setBrightness(50);
  strip.show(); // Initialize all pixels to 'off'

  pinMode(stomer1, OUTPUT);
  pinMode(stomer2, OUTPUT);

  digitalWrite(stomer1, HIGH);
  digitalWrite(stomer2, HIGH);

  delay(10000);
}

void loop() {
  // Some example procedures showing how to display to the pixels:

  ToggleStomer(1);
  colorWipe(strip.Color(255, 0, 0), 50); // Red
  ToggleStomer(1);

  delay(1000);

  ToggleStomer(2);
  colorWipe(strip.Color(0, 255, 0), 50); // Green

  delay(1000);

  ToggleStomer(1);
  colorWipe(strip.Color(0, 0, 255), 50); // Blue
  ToggleStomer(2);
  ToggleStomer(1);

  delay(1000);

  ToggleStomer(2);
  theaterChase(strip.Color(127, 127, 127), 50); // White
  ToggleStomer(2);

  ToggleStomer(1);
  theaterChase(strip.Color(127, 0, 0), 50); // Red
  ToggleStomer(1);

  ToggleStomer(1);
  ToggleStomer(2);
  theaterChase(strip.Color(0, 0, 127), 50); // Blue
  ToggleStomer(2);
  ToggleStomer(1);

  rainbow(20);
  StoomShow();

  rainbowCycle(20);
  StoomShow();

  theaterChaseRainbow(50);
  StoomShow();
}


// Fill the dots one after the other with a color
void colorWipe(uint32_t c, uint8_t wait) {
  for (uint16_t i = 0; i < strip.numPixels(); i++) {
    strip.setPixelColor(i, c);
    strip.show();
    delay(wait);
  }
}

void rainbow(uint8_t wait) {
  uint16_t i, j;

  for (j = 0; j < 256; j++) {
    for (i = 0; i < strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel((i + j) & 255));
    }
    strip.show();
    delay(wait);
  }
}

// Slightly different, this makes the rainbow equally distributed throughout
void rainbowCycle(uint8_t wait) {
  uint16_t i, j;

  for (j = 0; j < 256 * 5; j++) { // 5 cycles of all colors on wheel
    for (i = 0; i < strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel(((i * 256 / strip.numPixels()) + j) & 255));
    }
    strip.show();
    delay(wait);
  }
}

//Theatre-style crawling lights.
void theaterChase(uint32_t c, uint8_t wait) {
  for (int j = 0; j < 10; j++) { //do 10 cycles of chasing
    for (int q = 0; q < 3; q++) {
      for (uint16_t i = 0; i < strip.numPixels(); i = i + 3) {
        strip.setPixelColor(i + q, c);  //turn every third pixel on
      }
      strip.show();

      delay(wait);

      for (uint16_t i = 0; i < strip.numPixels(); i = i + 3) {
        strip.setPixelColor(i + q, 0);      //turn every third pixel off
      }
    }
  }
}

//Theatre-style crawling lights with rainbow effect
void theaterChaseRainbow(uint8_t wait) {
  for (int j = 0; j < 256; j++) {   // cycle all 256 colors in the wheel
    for (int q = 0; q < 3; q++) {
      for (uint16_t i = 0; i < strip.numPixels(); i = i + 3) {
        strip.setPixelColor(i + q, Wheel( (i + j) % 255)); //turn every third pixel on
      }
      strip.show();

      delay(wait);

      for (uint16_t i = 0; i < strip.numPixels(); i = i + 3) {
        strip.setPixelColor(i + q, 0);      //turn every third pixel off
      }
    }
  }
}

// Input a value 0 to 255 to get a color value.
// The colours are a transition r - g - b - back to r.
uint32_t Wheel(byte WheelPos) {
  WheelPos = 255 - WheelPos;
  if (WheelPos < 85) {
    return strip.Color(255 - WheelPos * 3, 0, WheelPos * 3);
  }
  if (WheelPos < 170) {
    WheelPos -= 85;
    return strip.Color(0, WheelPos * 3, 255 - WheelPos * 3);
  }
  WheelPos -= 170;
  return strip.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
}

void ToggleStomer(int nummer)
{
  if (nummer == 1)
  {
    digitalWrite(stomer1, LOW);
    delay(100);
    digitalWrite(stomer1, HIGH);
  }
  else
  {
    digitalWrite(stomer2, LOW);
    delay(100);
    digitalWrite(stomer2, HIGH);

  }
}

void StoomShow()
{
  delay(1000);

  ToggleStomer(1);
  delay(1000);
  ToggleStomer(1);

  ToggleStomer(2);
  delay(200);
  ToggleStomer(2);
  delay(200);
  ToggleStomer(2);
  delay(200);
  ToggleStomer(2);

  delay(500);

  ToggleStomer(2);
  delay(1000);
  ToggleStomer(2);

  ToggleStomer(1);
  delay(200);
  ToggleStomer(1);
  delay(200);
  ToggleStomer(1);
  delay(200);
  ToggleStomer(1);

  delay(1000);

  ToggleStomer(1);
  delay(10000);
  ToggleStomer(1);

  ToggleStomer(2);
  delay(10000);
  ToggleStomer(2);

  ToggleStomer(1);
  ToggleStomer(2);
  delay(10000);
  ToggleStomer(1);
  ToggleStomer(2);
}
