#include <SparkFunTSL2561.h>
#include <Wire.h>

SFE_TSL2561 light;

boolean gain;     // Gain setting, 0 = X1, 1 = X16;
unsigned int ms;  // Integration ("shutter") time in milliseconds
byte interruptPin = 2;
byte ledPin = 13;
volatile bool event = false;


void setup()
{
  pinMode(ledPin, OUTPUT);
  pinMode(interruptPin, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(interruptPin), blink, FALLING);
  Serial.begin(9600);
  Serial.println("TSL2561 example sketch with interrupts");

  light.begin();

  // If gain = false (0), device is set to low gain (1X)
  // If gain = high (1), device is set to high gain (16X)

  gain = 0;

  // If time = 0, integration will be 13.7ms
  // If time = 1, integration will be 101ms
  // If time = 2, integration will be 402ms
  // If time = 3, use manual start / stop to perform your own integration

  unsigned char time = 1;

  Serial.println("Set timing...");
  light.setTiming(gain, time, ms);
  Serial.print("ms: "); Serial.println(ms);
  
  // Sets up interrupt operations: setInterruptControl(control/persist)
  // If control = 0, interrupt output disabled
  // If control = 1, use level interrupt, see setInterruptThreshold()
  // If persist = 0, every integration cycle generates an interrupt
  // If persist = 1, any value outside of threshold generates an interrupt
  // If persist = 2 to 15, value must be outside of threshold for 2 to 15 integration cycles
  
  if (light.setInterruptControl(1, 2)) { //control=1, persist=2
    Serial.println("Interrupt Control: success");
  }
  if (light.setInterruptThreshold(150, 5000)) {
    Serial.println("Interrupt threshold set");
  }
  light.clearInterrupt();

  Serial.println("Powerup...");
  light.setPowerUp();
}

void loop()
{
  unsigned int data0, data1;

  if (light.getData(data0, data1))
  {
    Serial.print("data0: ");
    Serial.print(data0);
    Serial.print(" data1: ");
    Serial.print(data1);

    double lux;    // Resulting lux value
    boolean good;  // True if neither sensor is saturated
    good = light.getLux(gain, ms, data0, data1, lux);

    Serial.print(" lux: ");
    Serial.print(lux);
    if (good) Serial.println(" (good)"); else Serial.println(" (BAD)");
  }
  else
  {
    byte error = light.getError();
    printError(error);
  }
  if (event) {
    Serial.println("Interrupt!!");
    digitalWrite(ledPin, HIGH);
    delay(1000);
    digitalWrite(ledPin, LOW);
    event = false;
    light.clearInterrupt();

  }
}

void printError(byte error)
{
  Serial.print("I2C error: ");
  Serial.print(error, DEC);
  Serial.print(", ");

  switch (error)
  {
    case 0:
      Serial.println("success");
      break;
    case 1:
      Serial.println("data too long for transmit buffer");
      break;
    case 2:
      Serial.println("received NACK on address (disconnected?)");
      break;
    case 3:
      Serial.println("received NACK on data");
      break;
    case 4:
      Serial.println("other error");
      break;
    default:
      Serial.println("unknown error");
  }
}

void blink() {
  event = true;
}