
/*************************
  **   Custom functions   **
*************************/

void drawButtons()
{
  // Draw the upper row of buttons
  for (x = 0; x < 5; x++)
  {
    myGLCD.setColor(0, 0, 255);
    myGLCD.fillRoundRect (10 + (x * 40), 28, 40 + (x * 40), 58);
    myGLCD.setColor(255, 255, 255);
    myGLCD.drawRoundRect (10 + (x * 40), 28, 40 + (x * 40), 58);
    myGLCD.printNumI(x + 1, 18 + (x * 40), 36);
  }
  // Draw the center row of buttons
  for (x = 0; x < 5; x++)
  {
    myGLCD.setColor(0, 0, 255);
    myGLCD.fillRoundRect (10 + (x * 40), 70, 40 + (x * 40), 100);
    myGLCD.setColor(255, 255, 255);
    myGLCD.drawRoundRect (10 + (x * 40), 70, 40 + (x * 40), 100);

    if (x < 4)
    {
      myGLCD.printNumI(x + 6, 18 + (x * 40), 78);
    }
    else
    {
      myGLCD.printNumI(0, 18 + (x * 40), 78);
    }
  }

  // Draw the lower row of buttons
  myGLCD.setColor(0, 0, 255);
  myGLCD.fillRoundRect (10, 130, 150, 160);
  myGLCD.setColor(255, 255, 255);
  myGLCD.drawRoundRect (10, 130, 150, 160);
  myGLCD.print("Clear", 40, 137);

  myGLCD.setColor(0, 0, 255);
  myGLCD.fillRoundRect (160, 130, 300, 160);
  myGLCD.setColor(255, 255, 255);
  myGLCD.drawRoundRect (160, 130, 300, 160);
  myGLCD.print("Print", 190, 137);
  
  myGLCD.setColor(0, 0, 255);
  myGLCD.fillRoundRect (160, 170, 300, 200);
  myGLCD.setColor(255, 255, 255);
  myGLCD.drawRoundRect (160, 170, 300, 200);
  myGLCD.print("Linefeed", 165, 177);
  
  
  myGLCD.setBackColor (0, 0, 0);
}

void updateStr(int val)
{
  if (stCurrentLen < 20)
  {
    stCurrent[stCurrentLen] = val;
    stCurrent[stCurrentLen + 1] = '\0';
    stCurrentLen++;
    myGLCD.setColor(0, 255, 0);
    myGLCD.print(stCurrent, LEFT, 224);
  }
  else
  {
    myGLCD.setColor(255, 0, 0);
    myGLCD.print("BUFFER FULL!", CENTER, 192);
    delay(500);
    myGLCD.print("            ", CENTER, 192);
    delay(500);
    myGLCD.print("BUFFER FULL!", CENTER, 192);
    delay(500);
    myGLCD.print("            ", CENTER, 192);
    myGLCD.setColor(0, 255, 0);
  }
}

// Draw a red frame while a button is touched
void waitForIt(int x1, int y1, int x2, int y2)
{
  myGLCD.setColor(255, 0, 0);
  myGLCD.drawRoundRect (x1, y1, x2, y2);
  while (myTouch.dataAvailable())
    myTouch.read();
  myGLCD.setColor(255, 255, 255);
  myGLCD.drawRoundRect (x1, y1, x2, y2);
}

/*************************
**  Required functions  **
*************************/

void setupScreen()
{
  // Initial setup
  myGLCD.InitLCD();
  myGLCD.clrScr();

  myTouch.InitTouch();
  myTouch.setPrecision(PREC_MEDIUM);

  myGLCD.setFont(BigFont);
 
  myGLCD.setColor(VGA_YELLOW);
  myGLCD.print("*** Printer test ***", CENTER, 0);

  myGLCD.setFont(SmallFont);
  myGLCD.setColor(VGA_WHITE);
  myGLCD.print("By", 220, 36);
  myGLCD.print("John Sanders", 220, 50);
  myGLCD.print("25-04-2015", 220, 80);
  
  myGLCD.setBackColor(0, 0, 255);
  myGLCD.setFont(BigFont);
    
  drawButtons();

  Serial.begin(9600);
}


