void InitPrinter()
{
  pinMode(D0, OUTPUT);
  pinMode(D1, OUTPUT);
  pinMode(D2, OUTPUT);
  pinMode(D3, OUTPUT);
  pinMode(D4, OUTPUT);
  pinMode(D5, OUTPUT);
  pinMode(D6, OUTPUT);
  pinMode(D7, OUTPUT);

  pinMode(STROBE, OUTPUT);
  digitalWrite(STROBE, HIGH);

  pinMode(BUSY, INPUT_PULLUP);
}

void printCentronics(String letters)
{
  int lengte = letters.length();

  for (int teller = 0; teller < lengte; teller++ )
  {
    char teken = letters.charAt(teller);
    int ascii = teken;

    outputToCentronic(ascii);
  }

  outputToCentronic(13);
}

void outputToCentronic(byte teken)
{
  setdataBit(D7, teken & 128);
  setdataBit(D6, teken & 64);
  setdataBit(D5, teken & 32);
  setdataBit(D4, teken & 16);

  setdataBit(D3, teken & 8);
  setdataBit(D2, teken & 4);
  setdataBit(D1, teken & 2);
  setdataBit(D0, teken & 1);

  delay(1);

  // Latch data
  digitalWrite(STROBE, LOW);
  delayMicroseconds(1);
  digitalWrite(STROBE, HIGH);

  // Wait fore ready
  while (digitalRead(BUSY))
  {
  }
}

void setdataBit(int poort, bool high)
{
  if (high)
  {
    digitalWrite(poort, HIGH);
  }
  else
  {
    digitalWrite(poort, LOW);
  }
}
