/************************************************************************************
  All materials are provided by www.ICStation.com.
Should you have any unclear or need any other related material, please feel free to 
contact us via http://www.icstation.com/contact_us.php.
www.ICStation.com
   ICStation is based in Shenzhen, China, a city which is rich in electronics. 
With such manufacture power, we not only provide worldwide with all kinds of 
IC products, such as electronic devices and components, development modules, 
development boards, consumptive materials and so on, but also we are taking 
part in the designing and developing digital and analog circuit design which
 based on  microcontroller platforms.
**************************************************************************************/
#include "ICStation_Light_cube.h"
int ICStation_Light_cube::LEDPin[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
int ICStation_Light_cube::PlanePin[4] = {16, 17, 18, 19};
unsigned char ICStation_Light_cube::PatternTable[]= {
B0001,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0111,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0111,B0111,B0111,B0111,B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0011,B0011,B0011,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10,
B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,10,
B0100,B0010,B0001,B0001,B0100,B0010,B0001,B0001,B0100,B0010,B0001,B0001,B0100,B0010,B0001,B0001,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0010,B0100,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0010,B0100,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0100,B0000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0100,B0000,10,
};
unsigned int ICStation_Light_cube::HC_595_Temp = 0;
int ICStation_Light_cube::clockPin=0;  //SH_CP of 74HC595 
int ICStation_Light_cube::latchPin=1;  //ST_CP of 74HC595 
int ICStation_Light_cube::dataPin=3;  //DS of 74HC595 
int ICStation_Light_cube::HC_595_E = 2;  
int ICStation_Light_cube::LED_Pin16= 4;
int ICStation_Light_cube::LED_Pin17= 5;
int ICStation_Light_cube::LED_Pin18= 6;
int ICStation_Light_cube::LED_Pin19= 7;

 #define ICStation_delay_MAX 10000  // 特效时间设置
 int ICStation_Light_cube::ICStation_delay =ICStation_delay_MAX;

 
 int ICStation_Light_cube::PatternIdx =0;// indexes which byte from pattern buffer
int ICStation_Light_cube::PatternMax = sizeof(PatternTable);



ICStation_Light_cube:: ICStation_Light_cube()
{
  

pinMode( latchPin, OUTPUT );
pinMode( clockPin, OUTPUT );
pinMode( dataPin, OUTPUT );
pinMode( HC_595_E, OUTPUT );

pinMode( LED_Pin16, OUTPUT );
pinMode( LED_Pin17, OUTPUT );
pinMode( LED_Pin18, OUTPUT );
pinMode( LED_Pin19, OUTPUT );

digitalWrite(LED_Pin16,LOW);
digitalWrite(LED_Pin17,LOW);
digitalWrite(LED_Pin18,LOW);
digitalWrite(LED_Pin19,LOW);


}

ICStation_Light_cube:: ~ICStation_Light_cube()
{
}



//transfer the data to LED
void ICStation_Light_cube::my_display(unsigned char *planeBuf)
{
int i = 0, j = 0;
for(j = 0; j < 16; j++)
{
dight_write_LED_pin(LEDPin[j], LOW);
}

for(j = 0; j < 16; j++)
{
      for(i = 0; i < 4; i++)
       {
        if(planeBuf[j] >> i & B0001)
         {
         dight_write_LED_pin(LEDPin[4 * (j % 4) + i], HIGH);
         }
}
}


}




void ICStation_Light_cube::write_74HC595(void){ 
   digitalWrite(latchPin, LOW); 
   
   digitalWrite(HC_595_E, HIGH); 
   shiftOut(dataPin, clockPin, LSBFIRST, HC_595_Temp);  
   shiftOut(dataPin, clockPin, LSBFIRST, (HC_595_Temp >> 8));
   digitalWrite(latchPin, HIGH);
   digitalWrite(HC_595_E, LOW);  
 }
 
 
 /*******************************************************************
 * parameter：1.Value：74HC595 Pin number
*             2.charge： output LOW or High 
 *function:  To convert 74 hc595 are needed for the I/o output
 *           note:for other application the Value should be lower 16
 *******************************************************************/
 void ICStation_Light_cube::dight_write_LED_pin( int value,int charge)
 {
   if(value > 19) return;
   if(charge != LOW && charge != HIGH) return;
  if(charge == LOW) 
  {
   switch (value)
   {
     case 0:  HC_595_Temp &=~_BV(15); break;
     case 1:  HC_595_Temp &=~_BV(14); break;
     case 2:  HC_595_Temp &=~_BV(13); break;
     case 3:  HC_595_Temp &=~_BV(12); break;
     case 4:  HC_595_Temp &=~_BV(11); break;
     case 5:  HC_595_Temp &=~_BV(10); break;
     case 6:  HC_595_Temp &=~_BV(9); break;
     case 7:  HC_595_Temp &=~_BV(8); break;
     case 8:  HC_595_Temp &=~_BV(7); break;
     case 9:  HC_595_Temp &=~_BV(6); break;
     case 10:  HC_595_Temp &=~_BV(5); break;
     case 11:  HC_595_Temp &=~_BV(4); break;
     case 12:  HC_595_Temp &=~_BV(3); break;
     case 13:  HC_595_Temp &=~_BV(2); break;
     case 14:  HC_595_Temp &=~_BV(1); break;
     case 15:  HC_595_Temp &=~_BV(0); break; 
     case 16: digitalWrite(LED_Pin16,LOW); break;
      case 17: digitalWrite(LED_Pin17,LOW); break;   
   }
  }
  else
  {
    switch (value)
   {
     case 0:  HC_595_Temp |=_BV(15); break;
     case 1:  HC_595_Temp |=_BV(14); break;
     case 2:  HC_595_Temp |=_BV(13); break;
     case 3:  HC_595_Temp |=_BV(12); break;
     case 4:  HC_595_Temp |=_BV(11); break;
     case 5:  HC_595_Temp |=_BV(10); break;
     case 6:  HC_595_Temp |=_BV(9); break;
     case 7:  HC_595_Temp |=_BV(8); break;
     case 8:  HC_595_Temp |=_BV(7); break;
     case 9:  HC_595_Temp |=_BV(6); break;
     case 10:  HC_595_Temp |=_BV(5); break;
     case 11:  HC_595_Temp |=_BV(4); break;
     case 12:  HC_595_Temp |=_BV(3); break;
     case 13:  HC_595_Temp |=_BV(2); break;
     case 14:  HC_595_Temp |=_BV(1); break;
     case 15:  HC_595_Temp |=_BV(0); break;  
     case 16: digitalWrite(LED_Pin16,HIGH); break;
     case 17: digitalWrite(LED_Pin17,HIGH); break;    
   }   
  }
     write_74HC595();
 }






 void ICStation_Light_cube::run_example(void)
 {

unsigned char PatternBuf[16]; // saves current pattern from PatternTable

// loop over entries in pattern table – while PatternIdx < PatternMax
int i = 0;

if(ICStation_delay == ICStation_delay_MAX)
{
 ICStation_delay = 0;
 for(i = 0; i < 16; i++)
{
PatternBuf[i] = PatternTable[PatternIdx++];
}
my_display(PatternBuf);
PatternIdx++; 
if(PatternIdx >= PatternMax) PatternIdx =0;
 
}
else{
 ++ICStation_delay; 
}


 }


