// Code corrected and amended by John Longworth BSc Hons October 2015  jlongworth55@yahoo.co.uk
// OCT32012 editing changes to adapt this program to work with shift registers,
// and to work with Common Cathode LED cube.

// Pins for UNO & MEGA with 4x4x4 ICStation shield
// Pins D0 - D15 are connected to the outputs of the 2 595 ICs

#include <avr/pgmspace.h>      // allows use of PROGMEM to store patterns in flash
#define LatchPin 1             // Pin connected to Pin 12 of 74HC595 (Latch STCP)
#define ClockPin 0             // Pin connected to Pin 11 of 74HC595 (Clock SHCP)
#define DataPin  3             // Pin connected to Pin 14 of 74HC595 (Data DS) 
#define OEPin    2             // Pin connected to Pin 13 of 74HC595 (Output Enable OE)
unsigned long endTime;         // Duration of pattern display
int displayTime = 100;         // Time to display pattern
byte planePin[] {7,6,5,4};     // D16 - D19 Ground for each plane  D16 - Top plane  D19 Bottom plane
int p[8] = {0,0,0,0,0,0,0,0};  // Passes pattern values to patDisplay()

// LED Pattern Table in PROGMEM - last column is display time in 100ms units
const unsigned char PROGMEM patterns[] = {
//1     2     3     4     5     6     7     8     9     10    11    12    13    14    15    16  
B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,5, //start stairs up down and around outside
B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,5,
B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,5,
B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,5,
B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,10,
B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,5,
B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,5,
B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,5,
B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,5, //second time
B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,5,
B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,5,
B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,5,
B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,10,
B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,5,
B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,5,
B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,5,
B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, //start 2x2 in and out
B0000,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,20, //ends and gos into box 2X2
B0000,B0000,B0000,B0000,B0011,B0000,B0000,B0000,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,20,
B0000,B0000,B0000,B0000,B0011,B0010,B0000,B0000,B0011,B0010,B0000,B0000,B0000,B0000,B0000,B0000,20,
B0000,B0000,B0000,B0000,B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,20,
B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,20,
B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,20,
B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,20,
B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, //to bigger box 3x3
B0000,B0000,B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0001,B0011,B0111,B0000,B0001,B0011,B0111,B0000,B0000,B0001,B0011,B0000,B0000,B0000,B0000,10,
B0000,B0011,B0111,B0111,B0000,B0011,B0011,B0111,B0000,B0001,B0011,B0111,B0000,B0000,B0000,B0000,10,
B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0011,B0111,B0111,B0000,B0000,B0000,B0000,10,
B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0000,B0000,B0000,20, //cube done starts moving 
B0000,B0000,B0000,B0000,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,10,
B0000,B0000,B0000,B0000,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,10,
B0000,B0000,B0000,B0000,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1100,B1110,B1110,10,
B0000,B0000,B0000,B0000,B0000,B1100,B1110,B1110,B0000,B1100,B1100,B1110,B0000,B1000,B1100,B1110,10,
B0000,B0000,B0000,B0000,B0000,B1000,B1100,B1110,B0000,B1000,B1100,B1110,B0000,B0000,B1000,B1100,10,
B0000,B0000,B0000,B0000,B0000,B0000,B1100,B1100,B0000,B0000,B1100,B1100,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1100,B1100,B0000,B0000,B1100,B1100,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B1100,B0000,B0000,B1100,B1100,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0000,B1000,B1100,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,10, //worm starts
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1100,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1110,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0111,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0011,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0011,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0011,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0010,B0010,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0110,B0010,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0110,B0100,B0100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0100,B0100,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0000,B0100,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B1000,B0000,B0000,B0000,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B1000,B1000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, //filling of bottom layer begins
B1100,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B1100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B1100,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B1100,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B1110,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1110,B1110,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B1110,B1110,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1110,B1110,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1110,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, //filling ends fliping to left side begins
B0111,B0111,B0111,B0111,B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0011,B0011,B0011,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,10, //end flip
B0010,B0010,B0010,B0010,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10, //flip to top begins
B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10,
B1000,B1000,B1000,B1000,B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0001,B0001,B0001,B0001,10,
B0000,B0000,B0000,B0000,B1000,B1000,B1000,B1000,B0100,B0100,B0100,B0010,B0011,B0011,B0011,B0011,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B1000,B1000,B0100,B0111,B0111,B0111,B0111,10,//end flip
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B1111,B1111,10,//begin flip to back
B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B1111,10,
B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,10,
B0000,B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,10,
B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,10,//end flip
B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,B0000,B0000,B1111,B0000,10,//start flip to bottom
B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,B0000,B0000,B1111,B0000,B0000,B1111,B0000,B0000,10,
B0000,B0000,B0000,B1111,B0000,B0000,B1111,B0000,B0000,B1111,B0000,B0000,B1111,B0000,B0000,B0000,10,
B0000,B0000,B1111,B1111,B0000,B1111,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0111,B0111,B0111,B0111,B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,//repeat
B0011,B0011,B0011,B0011,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,10, //end flip
B0010,B0010,B0010,B0010,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10, //flip to top begins
B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10,
B1000,B1000,B1000,B1000,B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0001,B0001,B0001,B0001,10,
B0000,B0000,B0000,B0000,B1000,B1000,B1000,B1000,B0100,B0100,B0100,B0010,B0011,B0011,B0011,B0011,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B1000,B1000,B0100,B0111,B0111,B0111,B0111,10,//end flip
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B1111,B1111,10,//begin flip to back
B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B1111,10,
B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,10,
B0000,B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,10,
B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,10,//end flip on back
B0000,B0000,B0001,B1110,B0000,B0000,B0001,B1110,B0000,B0000,B0001,B1110,B0000,B0000,B0001,B1110,10,//begins to turn to diagnal
B0000,B0001,B0010,B1100,B0000,B0001,B0010,B1100,B0000,B0001,B0010,B1100,B0000,B0001,B0010,B1100,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,//begin spinning              //1
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,//at other diagnal
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,//begin spinning              //2
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,//at other diagnal
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,//begin spinning              //3
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,//at other diagnal
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,//begin spinning             //4
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,//at other diagnal
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,//begin spinning             //5
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,//at other diagnal
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,//begin spinning             //6
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,//at other diagnal
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,//end spiral seires
B0001,B0001,B0010,B0100,B0001,B0001,B0010,B0100,B0001,B0001,B0010,B0100,B0001,B0001,B0010,B0100,10,//start to end on left side
B0001,B0001,B0001,B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,B0010,10,//end all on left side
B0010,B0010,B0010,B0010,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10,//start to go diagnal sideways
B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10,
B1000,B1000,B1000,B1000,B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0001,B0001,B0001,B0001,10,//end in diagnal 
B0000,B0000,B0000,B0000,B1100,B1100,B1100,B1100,B0011,B0011,B0011,B0011,B0000,B0000,B0000,B0000,10,//begin side spiral            //1
B0000,B0000,B0000,B0000,B0011,B0011,B0011,B0011,B1100,B1100,B1100,B1100,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,//at other diagnal
B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,10,
B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,10,
B0000,B0000,B0000,B0000,B1100,B1100,B1100,B1100,B0011,B0011,B0011,B0011,B0000,B0000,B0000,B0000,10,//begin side spiral            //2
B0000,B0000,B0000,B0000,B0011,B0011,B0011,B0011,B1100,B1100,B1100,B1100,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,//at other diagnal
B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,10,
B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,10,
B0000,B0000,B0000,B0000,B1100,B1100,B1100,B1100,B0011,B0011,B0011,B0011,B0000,B0000,B0000,B0000,10,//begin side spiral           //3
B0000,B0000,B0000,B0000,B0011,B0011,B0011,B0011,B1100,B1100,B1100,B1100,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,//at other diagnal
B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,10,
B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,10,
B0000,B0000,B0000,B0000,B1100,B1100,B1100,B1100,B0011,B0011,B0011,B0011,B0000,B0000,B0000,B0000,10,//begin side spiral           //4
B0000,B0000,B0000,B0000,B0011,B0011,B0011,B0011,B1100,B1100,B1100,B1100,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,//at other diagnal
B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,10,
B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,10,
B0000,B0000,B0000,B0000,B1100,B1100,B1100,B1100,B0011,B0011,B0011,B0011,B0000,B0000,B0000,B0000,10,//begin side spiral           //5
B0000,B0000,B0000,B0000,B0011,B0011,B0011,B0011,B1100,B1100,B1100,B1100,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,//at other diagnal
B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,10,
B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,10,
B0000,B0000,B0000,B0000,B1100,B1100,B1100,B1100,B0011,B0011,B0011,B0011,B0000,B0000,B0000,B0000,10,//begin side spiral           //5
B0000,B0000,B0000,B0000,B0011,B0011,B0011,B0011,B1100,B1100,B1100,B1100,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,//at other diagnal
B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,10,
B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,10,
B0000,B0000,B0000,B0000,B1100,B1100,B1100,B1100,B0011,B0011,B0011,B0011,B0000,B0000,B0000,B0000,10,//begin side spiral           //5
B0000,B0000,B0000,B0000,B0011,B0011,B0011,B0011,B1100,B1100,B1100,B1100,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10, //end side spirals
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,10, //transition to left side
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10,
B0010,B0001,B0001,B0001,B0010,B0010,B0001,B0001,B0001,B0001,B0010,B0010,B0001,B0001,B0001,B0010,10,
B0100,B0010,B0001,B0001,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0010,B0001,B0001,B0010,B0100,10,
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,10,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,10,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,10,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,10,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,10,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,10,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,10,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,10,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,10,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,10,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,10,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,10,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,10,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,10,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,10,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,10,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,10,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,10,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,10,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,10,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,10,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,10,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,10,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,10,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,10,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,10,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,10,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,10,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,10,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,10,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,10,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,10,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,10,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,10,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,10,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,10,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,5,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,5,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,5,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,5,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,5,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,5,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,5,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,5,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,5,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,5,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,5,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,5,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,5,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,5,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,5,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,5,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,5,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,5,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,5,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,5,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,5,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,5,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,5,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,5,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,5,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,5,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,5,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,5,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,5,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,5,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,10,//1 //start corkscrew spiral
B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,10,//2
B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,10,//3
B0001,B0010,B0100,B1000,B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,10,//4
B0000,B0011,B1100,B0000,B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,10,//5
B0000,B1100,B0011,B0000,B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,10,//6
B1000,B0100,B0010,B0001,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0001,B0010,B0100,B1000,10,//1 //move out of cork spiral to right wall
B1000,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B1000,10,
B1000,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B0100,B1000,10, 
B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,10,
B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,10,//left wall falls
B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B0000,B1000,B1000,B1000,10,
B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B0000,B1000,B1000,B1000,B0000,B0000,B1000,B1000,10,
B1000,B1000,B1000,B1000,B0000,B1000,B1000,B1000,B0000,B0000,B1000,B1000,B0000,B0000,B0000,B1000,10,
B0000,B1000,B1000,B1000,B0000,B0000,B1000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,//filling of entire cube
B0000,B0000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1100,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B1100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B1100,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B1100,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B1110,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1110,B1110,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B1110,B1110,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1110,B1110,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1110,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B0000,B0000,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B0000,B0001,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B0001,B0001,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B0011,B0001,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B0111,B0001,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B0001,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1001,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1001,B1001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1001,B1001,B1001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1001,B1001,B1101,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1001,B1101,B1101,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1101,B1101,B1101,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1101,B1101,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1101,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0000,B0010,B0010,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0010,B0010,B0010,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0010,B0010,B0010,B0010,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0110,B0010,B0010,B0010,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0110,B0110,B0010,B0010,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0110,B0110,B0110,B0010,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0110,B0110,B0110,B0110,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0111,B0110,B0110,B1110,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0111,B0111,B1110,B1110,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0111,B1111,B1111,B1110,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,10, 
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1000,B0000,B0000,B0001,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1100,B0000,B0000,B0011,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1110,B0000,B0000,B0111,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0000,B1111,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0001,B1000,B1111,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1001,B1001,B1111,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1101,B1011,B1111,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,10,//fade out of outside
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0110,B0110,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,10,
B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,10,
B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,10,//fade of inside
B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,//end


B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,  // 164 steps
B0011,B0000,B0000,B0000,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0010,B0000,B0000,B0011,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0001,B0011,B0111,B0000,B0001,B0011,B0111,B0000,B0000,B0001,B0011,10,
B0000,B0000,B0000,B0000,B0000,B0011,B0111,B0111,B0000,B0011,B0111,B0111,B0000,B0001,B0011,B0111,10,
B0000,B0000,B0000,B0000,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0011,B0111,B0111,10,
B0000,B0000,B0000,B0000,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,10,
B0000,B0000,B0000,B0000,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,10,
B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B0000,B0000,B0000,10,
B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1100,B1110,B1110,B0000,B0000,B0000,B0000,10,
B0000,B1110,B1110,B1110,B0000,B1100,B1110,B1110,B0000,B1000,B1100,B1110,B0000,B0000,B0000,B0000,10,
B0000,B1100,B1110,B1110,B0000,B1000,B1100,B1110,B0000,B0000,B1000,B1100,B0000,B0000,B0000,B0000,10,
B0000,B1000,B1100,B1110,B0000,B0000,B1000,B1100,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B1100,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0110,B0000,B0000,B0000,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0010,B0000,B0000,B0000,B0011,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0011,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0001,B0001,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0001,B0001,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1110,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1100,B0000,B0000,B1000,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0000,B1100,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1110,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0111,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0001,B0011,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0001,B0001,B0000,B0001,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0001,B0000,B0000,B0011,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0111,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1110,B1000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1100,B1100,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B1110,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0111,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0011,B0000,B0000,10,
B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,10,
B0001,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0111,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0111,B0111,B0111,B0111,B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0011,B0011,B0011,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10,
B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,10,
B0100,B0010,B0001,B0001,B0100,B0010,B0001,B0001,B0100,B0010,B0001,B0001,B0100,B0010,B0001,B0001,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0010,B0100,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0010,B0100,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0100,B0000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0100,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0010,B0000,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0010,B0000,B1000,B0000,B0010,B1000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0010,B0000,B1000,B0000,B0010,B1000,B0000,B0000,B0000,B1000,B0000,10,
B0000,B0010,B0000,B1000,B0000,B0010,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0010,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0100,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0110,B0110,B0000,B0000,B0100,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1001,B0110,B0110,B1001,B0000,B0110,B0110,B0000,B0000,B0100,B0010,B0000,B0000,B0000,B0000,B0000,10,
B1101,B0111,B1110,B1011,B1001,B0110,B0110,B1001,B0000,B0110,B0110,B0000,B0000,B0100,B0010,B0000,10,
B1111,B1111,B1111,B1111,B1101,B0111,B1110,B1011,B1001,B0110,B0110,B1001,B0000,B0110,B0110,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1101,B0111,B1110,B1011,B1001,B0110,B0110,B1001,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1101,B0111,B1110,B1011,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,

B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,  // 264 steps
B0011,B0000,B0000,B0000,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0010,B0000,B0000,B0011,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0110,B0110,B0000,B0000,B0110,B0110,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0001,B0011,B0111,B0000,B0001,B0011,B0111,B0000,B0000,B0001,B0011,10,
B0000,B0000,B0000,B0000,B0000,B0011,B0111,B0111,B0000,B0011,B0111,B0111,B0000,B0001,B0011,B0111,10,
B0000,B0000,B0000,B0000,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0011,B0111,B0111,10,
B0000,B0000,B0000,B0000,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,10,
B0000,B0000,B0000,B0000,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,10,
B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B0000,B0000,B0000,10,
B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1100,B1110,B1110,B0000,B0000,B0000,B0000,10,
B0000,B1110,B1110,B1110,B0000,B1100,B1110,B1110,B0000,B1000,B1100,B1110,B0000,B0000,B0000,B0000,10,
B0000,B1100,B1110,B1110,B0000,B1000,B1100,B1110,B0000,B0000,B1000,B1100,B0000,B0000,B0000,B0000,10,
B0000,B1000,B1100,B1110,B0000,B0000,B1000,B1100,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B1100,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0110,B0000,B0000,B0000,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0010,B0000,B0000,B0000,B0011,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0011,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0001,B0001,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0001,B0001,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1110,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1100,B0000,B0000,B1000,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0000,B1100,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1110,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0111,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0001,B0011,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0001,B0001,B0000,B0001,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0001,B0000,B0000,B0011,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0111,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1110,B1000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1100,B1100,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B1110,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0111,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0011,B0000,B0000,10,
B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,10,
B0001,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0111,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B0111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0111,B0111,B0111,B0111,B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0011,B0011,B0011,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,B1000,B1000,B1000,B1000,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,B0100,B0100,B0100,B0100,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0010,B0010,B0010,B0010,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10,
B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,B0010,B0001,B0001,B0001,10,
B0100,B0010,B0001,B0001,B0100,B0010,B0001,B0001,B0100,B0010,B0001,B0001,B0100,B0010,B0001,B0001,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,10,
B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,B0100,B0100,B0010,B0010,10,
B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,B1000,B0100,B0010,B0001,10,
B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,B0000,B1100,B0011,B0000,10,
B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,B0000,B0011,B1100,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0010,B0100,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0010,B0100,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0100,B0000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0100,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0010,B0000,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0010,B0000,B1000,B0000,B0010,B1000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0010,B0000,B1000,B0000,B0010,B1000,B0000,B0000,B0000,B1000,B0000,10,
B0000,B0010,B0000,B1000,B0000,B0010,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0010,B1000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0100,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0110,B0110,B0000,B0000,B0100,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1001,B0110,B0110,B1001,B0000,B0110,B0110,B0000,B0000,B0100,B0010,B0000,B0000,B0000,B0000,B0000,10,
B1101,B0111,B1110,B1011,B1001,B0110,B0110,B1001,B0000,B0110,B0110,B0000,B0000,B0100,B0010,B0000,10,
B1111,B1111,B1111,B1111,B1101,B0111,B1110,B1011,B1001,B0110,B0110,B1001,B0000,B0110,B0110,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1101,B0111,B1110,B1011,B1001,B0110,B0110,B1001,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1101,B0111,B1110,B1011,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,10,
B0000,B0000,B0000,B0000,B0001,B0100,B0010,B1000,B1000,B0010,B0100,B0001,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B1000,B0010,B0100,B0001,B0001,B0100,B0010,B1000,B0000,B0000,B0000,B0000,10,
B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,10,
B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B0000,B0000,B1100,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,10,
B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,10,
B1100,B1100,B0000,B0000,B1100,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1100,B1100,B0000,B0000,B1100,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,10,
B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B1110,B1110,B1110,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1100,B1100,B0000,B0000,B1100,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,B1111,10,
B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0111,B0111,B0111,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0011,B0011,B0000,B0000,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0001,B0001,B0000,B0000,B0001,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0001,B0001,B0001,B0000,B0001,B0001,B0001,B0000,B0001,B0001,B0001,B0000,B0000,B0000,B0000,10,
B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,B0001,10,
B0000,B0000,B0000,B0000,B0001,B0001,B0001,B0000,B0001,B0001,B0001,B0000,B0001,B0001,B0001,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0001,B0000,B0000,B0001,B0001,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0011,B0000,B0000,B0000,B0011,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0111,B0000,B0000,B0000,B0111,B0000,B0000,B0000,B0111,B0000,B0000,B0000,10,
B1111,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,B0000,B0000,B0000,10,
B1110,B0000,B0000,B0000,B1110,B0000,B0000,B0000,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B0000,B0000,B0000,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B1000,B0000,B0000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B1000,B1000,B0000,B1000,B1000,B1000,B0000,B1000,B1000,B1000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,B1000,10,
B0000,B0000,B0000,B0000,B0000,B1000,B1000,B1000,B0000,B1000,B1000,B1000,B0000,B1000,B1000,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B1000,B0000,B0000,B1000,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1100,B0000,B0000,B0000,B1100,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1110,B0000,B0000,B0000,B1110,B0000,B0000,B0000,B1110,10,
B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,B0000,B0000,B0000,B1111,10,
B0000,B0000,B0000,B0111,B0000,B0000,B0000,B0111,B0000,B0000,B0000,B0111,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0011,B0000,B0000,B0000,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0001,B0000,B0111,B0111,B0011,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0111,B0111,B0111,10,

B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1111,B1111,B1111,B1111,10, // Rain 119 steps
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B1101,B1111,B1111,B1111,10,
B0000,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1101,B1111,B1111,B1111,10,
B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1101,B1111,B1111,B1111,10,
B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B1101,B1111,B1111,B0111,10,
B0010,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B1101,B1111,B1111,B0111,10,
B0010,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1101,B1111,B1111,B0111,10,
B0010,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0100,B0000,B1101,B1111,B1011,B0111,10,
B0010,B0000,B0000,B1000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,B0000,B1101,B1111,B1011,B0111,10,
B0010,B0000,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1101,B1111,B1011,B0111,10,
B0010,B0000,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B1101,B1110,B1011,B0111,10,
B0010,B0000,B0100,B1000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B1101,B1110,B1011,B0111,10,
B0010,B0001,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1101,B1110,B1011,B0111,10,
B0010,B0001,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0000,B1101,B0110,B1011,B0111,10,
B0010,B0001,B0100,B1000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B1101,B0110,B1011,B0111,10,
B0010,B1001,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1101,B0110,B1011,B0111,10,
B0010,B1001,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B1101,B0110,B1011,B0110,10,
B0010,B1001,B0100,B1000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B1101,B0110,B1011,B0110,10,
B0010,B1001,B0100,B1001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1101,B0110,B1011,B0110,10,
B0010,B1001,B0100,B1001,B0000,B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0101,B0110,B1011,B0110,10,
B0010,B1001,B0100,B1001,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0101,B0110,B1011,B0110,10,
B1010,B1001,B0100,B1001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0101,B0110,B1011,B0110,10,
B1010,B1001,B0100,B1001,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0000,B0101,B0110,B1010,B0110,10,
B1010,B1001,B0100,B1001,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0101,B0110,B1010,B0110,10,
B1010,B1001,B0101,B1001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0101,B0110,B1010,B0110,10,
B1010,B1001,B0101,B1001,B0000,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0001,B0110,B1010,B0110,10,
B1010,B1001,B0101,B1001,B0100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0110,B1010,B0110,10,
B1110,B1001,B0101,B1001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0110,B1010,B0110,10,
B1110,B1001,B0101,B1001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0001,B0110,B1010,B0100,10,
B1110,B1001,B0101,B1001,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0001,B0110,B1010,B0100,10,
B1110,B1001,B0101,B1011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0110,B1010,B0100,10,
B1110,B1001,B0101,B1011,B0000,B0000,B0000,B0000,B0000,B0100,B0000,B0000,B0001,B0010,B1010,B0100,10,
B1110,B1001,B0101,B1011,B0000,B0100,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B1010,B0100,10,
B1110,B1101,B0101,B1011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B1010,B0100,10,
B1110,B1101,B0101,B1011,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0001,B0010,B0010,B0100,10,
B1110,B1101,B0101,B1011,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B0010,B0100,10,
B1110,B1101,B1101,B1011,B0000,B0000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0010,B0010,B0100,10,
B1110,B1101,B1101,B1011,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0010,B0100,10,
B1111,B1101,B1101,B1011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0010,B0100,10,
B1111,B1101,B1101,B1011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0100,B0000,B0010,B0010,B0000,10,
B1111,B1101,B1101,B1011,B0000,B0000,B0000,B0100,B0000,B0000,B0000,B0000,B0000,B0010,B0010,B0000,10,
B1111,B1101,B1101,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0010,B0000,10,
B1111,B1101,B1101,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0000,B0000,B0010,B0000,B0000,10,
B1111,B1101,B1101,B1111,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0000,B0000,10,
B1111,B1101,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0000,B0000,10,
B1111,B1101,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1101,B1111,B1111,B0000,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B1111,B1111,B0111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0100,B1000,B0001,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0101,B1010,B0100,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0111,B0111,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B1111,B1111,B0111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0100,B1000,B0001,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0101,B1010,B0100,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0111,B0111,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B1111,B1111,B0111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0100,B1000,B0001,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0101,B1010,B0100,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0111,B0111,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B1111,B1111,B0111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1100,B0011,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B0000,B0000,B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0100,B1000,B0001,B0010,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0010,B0101,B1010,B0100,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0000,B0000,B0000,B0000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,10,
B0001,B0010,B0100,B1000,B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0001,B0010,B0100,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0111,B0111,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0011,B0111,B1110,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0111,B1111,B1111,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1111,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1110,B1111,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1100,B1110,B1111,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B1000,B1100,B1110,B1111,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B1000,B1100,B1110,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B1000,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B1000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B1000,B1100,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B1010,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B1000,B0000,B0000,B1001,10,
B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0100,B0000,B0101,B0000,B0000,B0000,B0000,B0000,10,
B0000,B0000,B0000,B0000,B0010,B0011,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,
B0001,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,B0000,10,


// this is a dummy element for end of table (duration=0) aka !!!DO NOT TOUCH!!!
B0000, B0000, B0000, B0000, B0000, B0000, B0000, B0000, B0000, B0000, B0000, B0000, B0000, B0000, B0000, B0000,0
};

/* Defining pins in array makes it easier to rearrange how cube is wired
   Adjust numbers here until LEDs flash in order - L to R, T to B
   Note that analog inputs 0-5 are also digital outputs 14-19!
   Pin DigitalOut0 (serial RX) and AnalogIn5 are left open for future apps

   Just a note to say we dont do things this way anymore. Data is serialized
   to pin 7 via 74hc595 shift registers, and the planes(layers) are controlled
   by pins 11,10,9,6. The first shift register controls the first 8 pins, the
   second shift register controls pins 9-16.
   Looking down on the cube, the column pin matrix looks like this:

   16 15 14 13
   12 11 10  9
    8  7  6  5
    4  3  2  1
This code is for a cube with common cathode, meaning send 5 volts to illuminate the individual led, and ground the plane(layer)
*/

void setup() {
  //Serial.begin(9600);  // Do not use in program
  pinMode(LatchPin, OUTPUT);
  pinMode(ClockPin, OUTPUT);
  pinMode(DataPin, OUTPUT);
  pinMode(OEPin, OUTPUT);
  digitalWrite(OEPin, LOW);
  for (int i = 0;i < 4; i++) {
    pinMode(planePin[i], OUTPUT);
    digitalWrite(planePin[i], LOW);     
  }
  endTime = millis() + 10;
}

void loop() {    
  byte patBuffer[16]; // saves current pattern from PatternTable
  int patIndex = 0;
  do {  
    patDisplay(p);   
    if (millis() > endTime) {
      memcpy_P(patBuffer, patterns + patIndex, 17); 
      patIndex+=17;
      for (int i = 0; i < 8; i++) {          
        p[i] = patBuffer[(i*2)] + patBuffer[(i*2)+1];          
      }
      displayTime = patBuffer[16];
      endTime = millis() + (displayTime * 20);                     
    }
  } while (displayTime > 0);      
}

void patDisplay(int p[8]) {
  allOff();   
  for (int i = 0;i < 4; i++) {
    digitalWrite(planePin[i], LOW);    // Turn plane on
    displayMatrix(p[i*2],p[(i*2)+1]);  // Display LEDs on the selected plane
    delayMicroseconds(4000);           // Wait
    digitalWrite(planePin[i], HIGH);   // Turn plane off
    displayMatrix(0,0);                // Turn all LEDs off
  }
}

void allOff() {
  displayMatrix(0,0);  // Turn off all 16 LEDs
  for (int i = 0;i < 4; i++) digitalWrite(planePin[i], HIGH);
}

void displayMatrix(int first8, int second8) {  // Write data to the 595 ICs
  digitalWrite(LatchPin, LOW); 
  shiftOut(DataPin, ClockPin, MSBFIRST, second8);  // D15 to D8
  shiftOut(DataPin, ClockPin, MSBFIRST, first8);   // D7 to D0      
  digitalWrite(LatchPin, HIGH);       
}
// The code above is my version
// The code below is the original that I found on the internet
/*void loop() {
  //Serial.println("Start");  // Do not use in program
  byte PatternBuf[PLANESIZE]; // saves current pattern from PatternTable
  int PatternIdx;
  byte DisplayTime; // time*100ms to display pattern
  unsigned long EndTime;
  int plane; // loop counter for cube refresh
  int patbufidx; // indexes which byte from pattern buffer
  int ledrow; // counts LEDs in refresh loop
  int ledcol; // counts LEDs in refresh loop
  int ledpin; // counts LEDs in refresh loop
  int pinState; //pinState is used to send the correct bit to the data pin  
  PatternIdx = 0;  // Initialize PatternIdx to beginning of pattern table  
  do {   // loop over entries in pattern table - while DisplayTime>0
    memcpy_P( PatternBuf, PatternTable+PatternIdx, PLANESIZE );  // read pattern from PROGMEM and save in array
    //Serial.println(PatternBuf[0]+PatternBuf[1]);
    PatternIdx += PLANESIZE;    
    DisplayTime = pgm_read_byte_near( PatternTable + PatternIdx++ );  // read DisplayTime from PROGMEM and increment index
    EndTime = millis() + ((unsigned long) DisplayTime) * TIMECONST;  // compute EndTime from current time (ms) and DisplayTime
    while ( millis() < EndTime ) {  // loop while DisplayTime>0 and current time < EndTime
      patbufidx = 0; // reset index counter to beginning of buffer
      // loop over planes
      for (plane=0;plane<CUBESIZE; plane++) {  // turn previous plane off (low is off, high is on)
        if (plane==0) {
          digitalWrite(PlanePin[CUBESIZE-1], LOW);
        } 
        else {
          digitalWrite(PlanePin[plane-1], LOW);
        } 
      }     
      digitalWrite(latchPin, 0);  //move 'em out    
      ledpin = 0;
      for (ledrow=0; ledrow<CUBESIZE; ledrow++) {
        for (ledcol=0; ledcol<CUBESIZE; ledcol++) {
          digitalWrite(clockPin, 0);        
          digitalWrite(dataPin, PatternBuf[patbufidx] & (1 << ledcol) );
          if (PatternBuf[patbufidx] & (1 << ledcol)) {
            pinState = 1; // Flip these bits to suit your cubes common lead (cathode or anode)
          }  
          else {
            pinState = 0; // Flip these bits to suit your cubes common lead (cathode or anode)
          }        
          //Sets the pin to HIGH or LOW depending on pinState
          digitalWrite(dataPin, pinState); // this is where data is sent to the shift register.
          //register shifts bits on upstroke of clock pin
          digitalWrite(clockPin, 1);        
          ledpin++;
        }
        patbufidx++;
      }
      digitalWrite(latchPin, 1);        
      digitalWrite(PlanePin[plane], HIGH);  // turn current plane on (plane high for on)    
      delayMicroseconds(PLANETIME);  // delay PLANETIME us
    } // for plane
  } while (DisplayTime > 0); // read patterns until time = 0 which signals end
}*/


