#include <SFE_BMP180.h>

// You will need to create an SFE_BMP180 object, here called "pressure":
SFE_BMP180 pressure;
#define ALTITUDE 18.6 // Altitude of SparkFun's HQ in Boulder, CO. in meters
float _BaroDruk;
float _HYT221Hyd;
float _HYT221Tmp;

#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
#include <avr/power.h>
#endif

#include <Wire.h>
#include "RTClib.h"
RTC_DS1307 rtc;

#include <SoftwareSerial.h>
SoftwareSerial mySerial(3, 2);

#define PIN 6
#define NUM_LEDS 6 * 7 + 2  // + 2 // 2x display and 2 dots and 2 test
int BRIGHTNESS = 25;
Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_LEDS, PIN, NEO_GRB + NEO_KHZ800);

int red = 0;
int green = 255;
int blue = 0;

uint32_t colorDot1 = strip.Color( 0xA7, 0x7B, 0x16);
uint32_t colorDot2 = strip.Color( 0xA7, 0x15, 0x5);
uint32_t colorDisplay1 = strip.Color( red, green, blue);
uint32_t colorDisplay2 = strip.Color( red, green, blue);
uint32_t colorDisplay3 = strip.Color( 0x16, 0xA7, 0xA7);
uint32_t colorReady = strip.Color( 255, 0, 0);

#define Off 0
#define Clock 1
#define CountDown 2
#define Datum 3
#define Temp 4
#define Baro 5
int Function = Clock;

bool DotOn = true;
DateTime OverTime(2019, 10, 26, 17, 5, 0);

void setup() {

  // set the data rate for the SoftwareSerial port
  mySerial.begin(57600);
  mySerial.println("Hello, by Big LED");

  Serial.begin(9600);

  if (! rtc.begin()) {
    Serial.println("Couldn't find RTC");
    while (1);
  }

  //rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));

  if (! rtc.isrunning()) {
    Serial.println("RTC is NOT running!");
    // following line sets the RTC to the date & time this sketch was compiled
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
    // This line sets the RTC with an explicit date & time, for example to set
    // January 21, 2014 at 3am you would call:
    // rtc.adjust(DateTime(2014, 1, 21, 3, 0, 0));
  }
  else
  {
    //rtc.adjust(DateTime(2018, 10, 6, 22, 0, 0));
  }

  if (pressure.begin())
  {
    Serial.println("BMP180 init success");
  }
  else
  {
    Serial.println("BMP180 init fail\n\n");
    while (1); // Pause forever.
  }

  #define HYT_ADDR 0x28     // I2C address of the HYT 221, 271, 371 and most likely the rest of the family
  Wire.begin();             // Join I2c Bus as master

  strip.setBrightness(BRIGHTNESS);
  strip.begin();
  strip.show(); // Initialize all pixels to 'off'

  DateTime nowX = rtc.now();
  OverTime = DateTime(nowX.year(), nowX.month(), nowX.day(), 15, 30, 0);
}

void loop() {
  // put your main code here, to run repeatedly:

  if (mySerial.available()) {
    delay(500);

    String data = "";

    while (mySerial.available() > 0)
    {
      byte inByte = mySerial.read();
      data += char(inByte);
    }

    mySerial.flush();

    DoCmd(data);
  }
  else
  {
    switch (Function)
    {
      case Clock:
        HandleClockDisplay();
        break;

      case CountDown:
        HandleCountDownDisplay();
        break;

      case Temp:
        HandleTempDisplay();
        break;

      case Datum:
        HandleDateDisplay();
        break;

      case Off:
        HandleOffDisplay();
        break;

      case Baro:
        HandleBaroDisplay();
        break;
    }

    delay(500);
  }
}

void HandleCountDownDisplay()
{
  DateTime nowX = rtc.now();

  auto leftTimeX = OverTime - nowX;

  uint16_t h = 0;
  uint8_t m = 0;
  uint8_t s = 0;

  int diff = OverTime.unixtime() - nowX.unixtime();

  if (diff > 0)
  {
    secondsToHMS(diff , h, m, s);

    DateTime leftTime = DateTime(1970, 1, 1, h, m, s);

    int H1 = leftTime.hour() / 10;
    int H2 = leftTime.hour() % 10;
    displayDigit(1, H1, colorDisplay1, false);
    displayDigit(2, H2, colorDisplay1, false);

    int M1 = leftTime.minute() / 10;
    int M2 = leftTime.minute() % 10;
    displayDigit(3, M1, colorDisplay2, false);
    displayDigit(4, M2, colorDisplay2, false);

    int S1 = leftTime.second() / 10;
    int S2 = leftTime.second() % 10;
    displayDigit(5, S1, colorDisplay3, false);
    displayDigit(6, S2, colorDisplay3, false);

    if (DotOn)
    {
      displayDot (false, colorDot1, true, colorDot2);
      DotOn = false;
    }
    else
    {
      displayDot (true, colorDot1, false, colorDot2);
      DotOn = true;
    }

  }
  else
  {
    if (DotOn)
    {
      displayDot (false, colorDot1, false, colorDot2);
      displayDigit(1, 0, colorDisplay1, false);
      displayDigit(2, 0, colorDisplay1, false);
      displayDigit(3, 0, colorDisplay2, false);
      displayDigit(4, 0, colorDisplay2, false);
      displayDigit(5, 0, colorDisplay2, false);
      displayDigit(6, 0, colorDisplay2, false);

      DotOn = false;
    }
    else
    {
      displayDot (true, colorReady, true, colorReady);
      displayDigit(1, 0, colorReady, true);
      displayDigit(2, 0, colorReady, true);
      displayDigit(3, 0, colorReady, true);
      displayDigit(4, 0, colorReady, true);
      displayDigit(5, 0, colorReady, true);
      displayDigit(6, 0, colorReady, true);

      DotOn = true;
    }
  }
}

void HandleBaroDisplay()
{
  GetBaroValue();

  int baro = _BaroDruk;
  int baroDec = (_BaroDruk - (int)_BaroDruk) * 100;

  int D1 = (int)(baro / 1000);
  int D2 = (int)((baro % 1000) / 100);
  int D3 = (int)((baro % 100) / 10);
  int D4 = (int)((baro % 10) / 1);
  int D5 = (int)baroDec / 10;
  int D6 = (int)baroDec % 10;

  displayDigit(1, D1, colorDisplay1, false);
  displayDigit(2, D2, colorDisplay1, false);
  displayDigit(3, D3, colorDisplay1, false);
  displayDigit(4, D4, colorDisplay1, false);

  displayDigit(5, D5, colorDisplay3, false);
  displayDigit(6, D6, colorDisplay3, false);

  displayDot (false, colorDot1, false, colorDot2);
}

void HandleTempDisplay()
{
  GetHygroValue();
  
  float celsius = _HYT221Tmp;
  int T1 = (int)celsius / 10;
  int T2 = (int)celsius % 10;
  int T3 = ((celsius - (int)celsius) * 10);

  float humidity = _HYT221Hyd + 0.5;
  if (humidity > 99)
  {
    humidity = 99;
  }
  int H1 = (int)humidity / 10;
  int H2 = (int)humidity % 10;

  displayDigit(1, T1, colorDisplay1, false);
  displayDigit(2, T2, colorDisplay1, false);
  displayDigit(3, T3, colorDisplay1, false);
  displayDigit(4, 0, colorDisplay1, true);
  displayDot (true, colorDisplay1, false, colorDisplay1);

  displayDigit(5, H1, colorDisplay3, false);
  displayDigit(6, H2, colorDisplay3, false);
}

void HandleClockDisplay() {
  // put your main code here, to run repeatedly:

  DateTime now = rtc.now();

  int H1 = now.hour() / 10;
  int H2 = now.hour() % 10;
  displayDigit(1, H1, colorDisplay1, false);
  displayDigit(2, H2, colorDisplay1, false);

  int M1 = now.minute() / 10;
  int M2 = now.minute() % 10;
  displayDigit(3, M1, colorDisplay2, false);
  displayDigit(4, M2, colorDisplay2, false);

  int S1 = now.second() / 10;
  int S2 = now.second() % 10;
  displayDigit(5, S1, colorDisplay3, false);
  displayDigit(6, S2, colorDisplay3, false);

  if (DotOn)
  {
    displayDot (false, colorDot1, true, colorDot2);
    DotOn = false;
  }
  else
  {
    displayDot (true, colorDot1, false, colorDot2);
    DotOn = true;
  }
}

void HandleDateDisplay() {
  // put your main code here, to run repeatedly:

  DateTime now = rtc.now();

  int D1 = now.day() / 10;
  int D2 = now.day() % 10;
  displayDigit(1, D1, colorDisplay1, false);
  displayDigit(2, D2, colorDisplay1, false);

  int M1 = now.month() / 10;
  int M2 = now.month() % 10;
  displayDigit(3, M1, colorDisplay2, false);
  displayDigit(4, M2, colorDisplay2, false);

  int year = now.year() % 100;

  int Y1 = year / 10;
  int Y2 = year % 10;
  displayDigit(5, Y1, colorDisplay3, false);
  displayDigit(6, Y2, colorDisplay3, false);

  displayDot (true, colorDot1, true, colorDot1);
}

void HandleOffDisplay()
{
  displayDigit(1, 0, colorDisplay1, true);
  displayDigit(2, 0, colorDisplay1, true);
  displayDigit(3, 0, colorDisplay1, true);
  displayDigit(4, 0, colorDisplay1, true);
  displayDigit(5, 0, colorDisplay1, true);
  displayDigit(6, 0, colorDisplay1, true);

  if (DotOn)
  {
    displayDot (true, colorDot1, false, colorDot1);
    DotOn = false;
  }
  else
  {
    displayDot (false, colorDot1, false, colorDot1);
    DotOn = true;
  }
}
