void BTEvent()
{
  if (mySerial.available()) {
    delay(500);

    String data = "";

    while (mySerial.available() > 0)
    {
      byte inByte = mySerial.read();
      data += char(inByte);
    }

    mySerial.flush();

    DoCmd(data);
  }
}

void DoCmd(String data)
{
  Serial.println(data);


mySerial.println("OK John");
mySerial.flush();

  if (splitString(data, 0, ':') == "color")
  {
    if (splitString(data, 1, ':') == "reset")
    {
      SetStandardColor();
    }
    else
    {
      data = splitString(data, 1, ':');

      red = splitString(data, 0, ',').toInt();
      green = splitString(data, 1, ',').toInt();
      blue = splitString(data, 2, ',').toInt();

      SetColor(red, green, blue, 0);
    }
  }

  if (splitString(data, 0, ':') == "dispcol")
  {
    data = splitString(data, 1, ':');

    int displayNr = splitString(data, 0, ',').toInt();
    red = splitString(data, 1, ',').toInt();
    green = splitString(data, 2, ',').toInt();
    blue = splitString(data, 3, ',').toInt();

    SetColor(red, green, blue, displayNr);
  }

  if (splitString(data, 0, ':') == "dotcol")
  {
    data = splitString(data, 1, ':');

    int displayNr = splitString(data, 0, ',').toInt();
    red = splitString(data, 1, ',').toInt();
    green = splitString(data, 2, ',').toInt();
    blue = splitString(data, 3, ',').toInt();

    SetColor(red, green, blue, displayNr + 3);
  }

  if (data.startsWith("dim:"))
  {
    BRIGHTNESS = splitString(data, 1, ':').toInt();
    strip.setBrightness(BRIGHTNESS);
  }

  if (data.startsWith("red:"))
  {
    red = splitString(data, 1, ':').toInt();
    SetColor(red, green, blue, 0);
  }

  if (data.startsWith("green:"))
  {
    green = splitString(data, 1, ':').toInt();
    SetColor(red, green, blue, 0);
  }

  if (data.startsWith("blue:"))
  {
    blue = splitString(data, 1, ':').toInt();
    SetColor(red, green, blue, 0);
  }

  if (data.startsWith("functie:"))
  {
    Function = splitString(data, 1, ':').toInt();
  }

  if (data.startsWith("alarm:"))
  {
    DateTime nowX = rtc.now();

    int h = splitString(data, 1, ':').toInt();
    int m = splitString(data, 2, ':').toInt();
    OverTime = DateTime(nowX.year(), nowX.month(), nowX.day(), h, m, 0);

    //Serial.println(splitString(data, 0, ':').toInt());
    //Serial.println(splitString(data, 1, ':').toInt());
    //Serial.println(splitString(data, 2, ':').toInt());
  }

  if (data.startsWith("time:"))
  {
    DateTime nowX = rtc.now();

    //Serial.println(data);

    int h = splitString(data, 1, ':').toInt();
    int m = splitString(data, 2, ':').toInt();
    int s = splitString(data, 3, ':').toInt();

    rtc.adjust(DateTime(nowX.year(), nowX.month(), nowX.day(), h, m, s));
  }

  if (data.startsWith("date:"))
  {
    data = splitString(data, 1, ':');
    DateTime nowX = rtc.now();

    //Serial.println(data);

    int y = splitString(data, 0, '-').toInt();
    int m = splitString(data, 1, '-').toInt();
    int d = splitString(data, 2, '-').toInt();

    rtc.adjust(DateTime(y, m, d, nowX.hour(), nowX.minute(), nowX.second()));
  }
}

void SetColor(int red, int green, int blue, int displayNr)
{
  if (displayNr == 0 || displayNr == 4)
  {
    colorDot1 = strip.Color( red, green, blue);
  }
  if (displayNr == 0 || displayNr == 5)
  {
    colorDot2 = strip.Color( red, green, blue);
  }
  if (displayNr == 0 || displayNr == 1)
  {
    colorDisplay1 = strip.Color( red, green, blue);
  }
  if (displayNr == 0 || displayNr == 2)
  {
    colorDisplay2 = strip.Color( red, green, blue);
  }
  if (displayNr == 0 || displayNr == 3)
  {
    colorDisplay3 = strip.Color( red, green, blue);
  }
}

void SetStandardColor()
{
  colorDot1 = strip.Color( 0xA7, 0x7B, 0x16);
  colorDot2 = strip.Color( 0xA7, 0x15, 0x5);
  colorDisplay1 = strip.Color( 0, 255, 0);
  colorDisplay2 = strip.Color( 0, 255, 0);
  colorDisplay3 = strip.Color( 0x16, 0xA7, 0xA7);
}
