byte numbers[] = {
  0b00111111, // 0
  0b00000110, // 1
  0b01011011, // 2
  0b01001111, // 3
  0b01100110, // 4
  0b01101101, // 5
  0b01111101, // 6
  0b00000111, // 7
  0b01111111, // 8
  0b01101111, // 9
  0b00000000, // clear
};


void displayDigit(int displayNumber, int number, uint32_t color, bool clear)
{

  int startindex = 0;
  int dotOffset = 2;


  // startindex = ((displayNumber - 1) * 7) + dotOffset;

  switch (displayNumber)
  {
    case 1:
      startindex = 0 + dotOffset;
      break;

    case 2:
      startindex = 7 + dotOffset;
      break;

    case 3:
      startindex = 14 + dotOffset;
      break;

    case 4:
      startindex = 21 + dotOffset;
      break;

    case 5:
      startindex = 28 + dotOffset;
      break;

    case 6:
      startindex = 35 + dotOffset;
      break;
  }

  //  Serial.print("Digit: ");
  //  Serial.print(displayNumber);
  //  Serial.print(" / ");
  //  Serial.print("displayDigit: ");
  //  Serial.print(number);
  ////  Serial.print(" / ");
  ////  Serial.print(numbers[number], BIN);
  //  Serial.print(" / ");
  //  Serial.print(startindex);

  if (clear)
  {
    number = 10;
  }

  byte digitalDefinition =  numbers[number];

  for (int i = 0; i < 7; i++)
  {
    if (digitalDefinition & (1 << i))
    {
      //strip.setPixelColor( i, strip.Color( redVal, greenVal, blueVal ) );
      //strip.setPixelColor( i + startindex, strip.Color( 0, 255, 0) );
      strip.setPixelColor( i + startindex, color );
    }
    else
    {
      strip.setPixelColor( i + startindex, strip.Color( 0, 0, 0) );
    }
  }

  strip.show();

  //Serial.println("");

}


void displayDot(bool dot1, uint32_t colorDot1, bool dot2, uint32_t colorDot2)
{
  if (dot1)
  {
    strip.setPixelColor( 0, colorDot1 );
  }
  else
  {
    strip.setPixelColor( 0, strip.Color( 0, 0, 0) );
  }

  if (dot2)
  {
    strip.setPixelColor(1, colorDot2 );
  }
  else
  {
    strip.setPixelColor(1, strip.Color( 0, 0, 0) );
  }

  strip.show();
}
