#include<string.h>
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);  // Set the LCD I2C address

byte buff[2];
int pin = 8;  //DSM501A Vout2 (PM10) Deze wordt alleen gebruikt.
// int pin = 9;  //DSM501A Vout1 (PM2.5)

unsigned long duration;
unsigned long starttime;
unsigned long endtime;
unsigned long sampletime_ms = 15000; //30000;
unsigned long lowpulseoccupancy = 0;
float ratio = 0;
float concentration = 0;

int wLed = 3;
int gLed = 4;
int yLed = 5;
int rLed = 6;
int bLed = 7;

int i = 0;
void setup()
{
  lcd.begin(20, 4);
  lcd.backlight();

  // Opwarmen, duurt 1 minuut
  Opwarmen();
  lcd.clear();

  lcd.setCursor(0, 0);
  lcd.print("Stof sensor DSM501A");
  lcd.setCursor(0, 1);
  lcd.print("Norm setting: PM10");

  Serial.begin(9600);
  pinMode(pin, INPUT);

  pinMode(wLed, OUTPUT);
  pinMode(gLed, OUTPUT);
  pinMode(yLed, OUTPUT);
  pinMode(rLed, OUTPUT);
  pinMode(bLed, OUTPUT);

  lcd.setCursor(3, 3);
  lcd.print("Check led's");
  CheckLeds();
  CleanRow(3);

  lcd.setCursor(0, 3);
  lcd.print("Status: Waiting");
  
  starttime = millis();
}
void loop()
{
  duration = pulseIn(pin, LOW);
  lowpulseoccupancy += duration;
  endtime = millis();

  if ((millis() - starttime) > sampletime_ms) //if the sampel time == 30s
  {
    ratio = (lowpulseoccupancy - endtime + starttime + sampletime_ms) / (sampletime_ms * 10.0); // Integer percentage 0=>100
    concentration = 1.1 * pow(ratio, 3) - 3.8 * pow(ratio, 2) + 520 * ratio + 0.62; // using spec sheet curve

    CleanRow(2);

    lcd.setCursor(0, 2);
    if (concentration > 50000 ) 
    {
      lcd.print("> 50000");
    }
    else
    {
      lcd.print(concentration, 2);
    }
    lcd.setCursor(10, 2);
    lcd.print("pcs/0.01cf");

    Serial.print("concentration = ");
    Serial.print(concentration);
    Serial.print(" pcs/0.01cf  -  ");

    digitalWrite(wLed, LOW);
    digitalWrite(gLed, LOW);
    digitalWrite(yLed, LOW);
    digitalWrite(rLed, LOW);
    digitalWrite(bLed, LOW);

    if (concentration < 1000) {
      lcd.setCursor(8, 3);
      lcd.print("Schoon    ");

      digitalWrite(wLed, HIGH);
    }
    else if (concentration > 1000 && concentration < 10000) {
      lcd.setCursor(8, 3);
      lcd.print("Goed      ");

      digitalWrite(gLed, HIGH);
    }
    else if (concentration > 10000 && concentration < 20000) {
      lcd.setCursor(8, 3);
      lcd.print("Acceptabel");
      digitalWrite(yLed, HIGH);
    }
    else if (concentration > 20000 && concentration < 50000) {
      lcd.setCursor(8, 3);
      lcd.print("Hoog      ");
      digitalWrite(rLed, HIGH);
    }
    else if (concentration > 50000 ) {
      lcd.setCursor(8, 3);
      lcd.print("Gevaarlijk");
      digitalWrite(bLed, HIGH);
    }

    lowpulseoccupancy = 0;

    starttime = millis();

    Serial.println("");
  }
}

void CleanRow(int rowNr)
{
  lcd.setCursor (0, rowNr);
  for (int i = 0; i < 20; ++i)
  {
    lcd.write(' ');
  }
}

void CheckLeds()
{
  for (int t = 0; t < 2; t++)
  {

    for (int t = 0; t < 5; t++)
    {
      digitalWrite(wLed + t, HIGH);
      delay(25);
      digitalWrite(wLed + t, LOW);

      delay(25);
    }

    for (int t = 4; t >= 0; t--)
    {
      digitalWrite(wLed + t, HIGH);
      delay(25);
      digitalWrite(wLed + t, LOW);

      delay(25);
    }
  }
}

void Opwarmen()
{
  lcd.clear();

  lcd.setCursor(3, 0);
  lcd.print("** OPWARMEN **");
  lcd.setCursor(3, 1);
  lcd.print("Duurt 1 minuut");

  int seconden = 60;

  while (seconden > 0)
  {
    seconden--;

    lcd.setCursor(2, 3);
    lcd.print("Nog ");
    lcd.print(seconden);
    lcd.print(" seconden  ");

    delay(1000);
  }
}
