#include <SoftwareSerial.h>

SoftwareSerial mySerial(11, 10); // RX, TX

// Relay 1 t/m 4 resp NANO pin D2 t/m D5
#define Relay_1 2
#define Relay_2 3
#define Relay_3 4
#define Relay_4 5

int      inByte = 0;

void setup() {
  Serial.begin(9600);

  pinMode(Relay_1, OUTPUT);
  pinMode(Relay_2, OUTPUT);
  pinMode(Relay_3, OUTPUT);
  pinMode(Relay_4, OUTPUT);

  // Reset alle relay's let op LOW is aan, HIGH is uit
  digitalWrite(Relay_1, HIGH);
  digitalWrite(Relay_2, HIGH);
  digitalWrite(Relay_3, HIGH);
  digitalWrite(Relay_4, HIGH);

  // BlueTooth
  mySerial.begin(9600);
}

void loop()
{
  String ontvangenData;

  // Haal de data op van de BleuTooth module
  while (mySerial.available() > 0) {
    String commando = mySerial.readString();

    Serial.println(commando);

    byte modeOutput; // LOW of HIGH
    int relayNummer = commando.substring(0, 1).toInt();

    // Bepaal of de schakelaar aan of uit moet
    // Let op LOW is aan, HIGH is uit
    if (commando.substring(1) == "aan")
    {
      Serial.println("Aan");
      modeOutput = LOW;
    }
    else
    {
      Serial.println("Uit");
      modeOutput = HIGH;
    }

    // Zet het juiste relay in de juiste positie
    switch (relayNummer) {
      case 1:
        digitalWrite(Relay_1, modeOutput);
        break;
      case 2:
        digitalWrite(Relay_2, modeOutput);
        break;
      case 3:
        digitalWrite(Relay_3, modeOutput);
        break;
      case 4:
        digitalWrite(Relay_4, modeOutput);
        break;
      default:
        break;
    }
  }
}
