#include "MAX17043.h"
#include "Wire.h"
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);  // Set the LCD I2C address

MAX17043 batteryMonitor;

#include "TM1651.h"
#define CLK 2//pins definitions for TM1651 and can be changed to other ports       
#define DIO 3
TM1651 batteryDisplay(CLK, DIO);

void setup() {
  Wire.begin();
  Serial.begin(9600);
  Serial.println("MAX17043 Example: reading voltage and SoC");
  Serial.println();

  batteryDisplay.init();
  batteryDisplay.set(BRIGHTEST);//BRIGHT_TYPICAL = 2,BRIGHT_DARKEST = 0,BRIGHTEST = 7;
  batteryDisplay.frame(FRAME_ON);//light the frame of the battery display

  lcd.begin(20, 4);
  lcd.backlight();
  lcd.clear();

  lcd.setCursor(1, 0);
  lcd.print("Lipo batt. monitor");
  lcd.setCursor(3, 1);
  lcd.print("** MAX17043 **");
 

  batteryMonitor.reset();
  batteryMonitor.quickStart();
  Serial.print("version is :");
  Serial.println(batteryMonitor.getVersion(), 4);

  lcd.setCursor(5, 2);
  lcd.print("version: ");
  lcd.print(batteryMonitor.getVersion());

  delay(1000);
}

void loop() {

  get_infor();

  delay(1000);
}

void set_batt(float stateOfCharge)
{
  uint8_t level = int(stateOfCharge) / 20;
  batteryDisplay.displayLevel(level);
}

void get_infor()
{
  float cellVoltage = batteryMonitor.getVCell();
  Serial.print("Voltage:\t\t");
  Serial.print(cellVoltage, 4);
  Serial.println("V");

  float stateOfCharge = batteryMonitor.getSoC();
  Serial.print("State of charge:\t");
  Serial.print(stateOfCharge);
  Serial.println("%");

  set_batt(stateOfCharge);

  lcd.setCursor(0, 3);
  lcd.print(cellVoltage, 3);
  lcd.print(" V / ");

  lcd.setCursor(10, 3);
  lcd.print(stateOfCharge);
  lcd.print(" %  ");
}
