Fingerprint Scanner-TTL
====================================

<table class="table table-hover table-striped table-bordered">
  <tr align="center">
    <td><a href="https://www.sparkfun.com/products/14518"><img src="https://cdn.sparkfun.com//assets/parts/1/2/5/9/1/14518-01.jpg" title="Fingerprint Scanner - TTL (GT-521F32)"></a></td>	
    <td><a href="https://www.sparkfun.com/products/14585"><img src="https://cdn.sparkfun.com//assets/parts/1/2/7/3/2/14585-Fingerprint_Scanner_-_TTL__GT-521F52_-01.jpg" title="Fingerprint Scanner - TTL (GT-521F52)"></a></td>
  <td><a href="https://www.sparkfun.com/products/11792"><img src="https://cdn.sparkfun.com//assets/parts/8/0/7/3/11792-04a.jpg" title="Fingerprint Scanner - TTL (GT-511C3)"></a></td>
  </tr>
  <tr align="center">
    <td><i>Fingerprint Scanner - TTL (GT-521F32) [<a href="https://www.sparkfun.com/products/14518">SEN-14518</a>]</i></td>
    <td><i>Fingerprint Scanner - TTL (GT-521F52) [<a href="https://www.sparkfun.com/products/14585">SEN-14585</a>]</i></td>
    <td><i>Fingerprint Scanner - TTL (GT-511C3)[<a href="https://www.sparkfun.com/products/11792">SEN-11792 (RETIRED)</a>]</i></td>
  </tr>
</table>

This is a great fingerprint module from ADH-Tech that communicates over 3.3V TTL Serial so you can easily embed it into your next project. This repository contains Arduino example code to work with it. This code has been tested with GT-521F32, GT-521F52, GT-511C3, and GT-511C1R.

Repository Contents
-------------------
* **/examples** - Example code to interface with the sensor.
* **/src** - Source files for the library (.cpp, .h).
* **keywords.txt** - Keywords from this library that will be highlighted in the Arduino IDE.
* **library.properties** - General library properties for the Arduino package manager.

Documentation
----------------
* [Installing an Arduino Library Guide](https://learn.sparkfun.com/tutorials/installing-an-arduino-library) - Basic information on how to install an Arduino library.
* [Fingerprint Scanner (GT-521Fxx) Hookup Guide](https://learn.sparkfun.com/tutorials/fingerprint-scanner-gt-521fxx-hookup-guide) - Hookup guide to connect to the GT-521F32 and GT-521F52.
* _[Fingerprint Scanner Hookup Guide (RETIRED)](https://learn.sparkfun.com/tutorials/fingerprint-scanner-hookup-guide) - Hookup guide to connect to the GT-511C3 and GT-511C1R._

Product Versions
----------------
* [SEN-14585](https://www.sparkfun.com/products/14585)- Fingerprint Scanner - TTL (GT-521F52)
* [SEN-14518](https://www.sparkfun.com/products/14518)- Fingerprint Scanner - TTL (GT-521F32)
* _[SEN-11792 (RETIRED)](https://www.sparkfun.com/products/11792)- Fingerprint Scanner - TTL (GT-511C3)_
* _[SEN-11651 (RETIRED)](https://www.sparkfun.com/products/11651)- Fingerprint Scanner - TTL (GT-511C2)_
* _[SEN-13007 (RETIRED)](https://www.sparkfun.com/products/13007)- Fingerprint Scanner - TTL (GT-511C1R)_
* _[SEN-11836 (RETIRED)](https://www.sparkfun.com/products/11836)- Fingerprint Scanner - 5V TTL (GT-511C1)_

Version History
---------------
* [V1.1.1](https://github.com/sparkfun/Fingerprint_Scanner-TTL/releases/tag/v1.1.1) - Add comments when using with GT-521F52
* [V1.1.0](https://github.com/sparkfun/Fingerprint_Scanner-TTL/releases/tag/v1.1.0) - Updated to new Arduino library structure
* [V1.0.0](https://github.com/sparkfun/Fingerprint_Scanner-TTL/releases/tag/v1.0.0) - Untracked version

License Information
-------------------

The original library license is as follows:

"	Created by Josh Hawley, July 23rd 2013
	Licensed for non-commercial use, must include this license message
	basically, Feel free to hack away at it, but just give me credit for my work =)
	TLDR; Wil Wheaton's Law "
