#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x26, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);  // Set the LCD I2C address

#include <Adafruit_Sensor.h>
#include <DHT.h>
#include <DHT_U.h>

#define DHTPIN 2
#define SmokePin 3

// Selecteer de juiste sensor
//#define DHTTYPE    DHT11     // DHT 11
#define DHTTYPE    DHT22     // DHT 22 (AM2302)
//#define DHTTYPE    DHT21     // DHT 21 (AM2301)

DHT_Unified dht(DHTPIN, DHTTYPE);

uint32_t delayMS;

bool BevochtigerAan = false;
float BevochtigerLow = 69.5;
float BevochtigerHigh = 70.0;

void setup() {
  lcd.begin(20, 4);
  // clear the LCD screen:
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Arduino auto Hygro");


  lcd.setCursor(0, 3);
  lcd.print("Range: ");
  lcd.print(BevochtigerLow, 1);
  lcd.print(F("-"));
  lcd.print(BevochtigerHigh, 1);
  lcd.print(F(" %"));

  dht.begin();

  sensor_t sensor;
  dht.temperature().getSensor(&sensor);
  dht.humidity().getSensor(&sensor);
  delayMS = sensor.min_delay / 1000;

  pinMode(SmokePin, OUTPUT);
  digitalWrite(SmokePin, HIGH);
}

void loop() {
  delay(delayMS);

  // Haal de waardes op
  sensors_event_t event;

  // Presenteer de temperatuur
  dht.temperature().getEvent(&event);
  if (isnan(event.temperature)) {
    lcd.clear();
    lcd.setCursor(0, 1);
    lcd.print(F("   Error  reading   "));
    lcd.setCursor(0, 2);
    lcd.print(F("    temperature!    "));
  }
  else {
    lcd.setCursor(0, 1);
    lcd.print("Temp.: ");
    lcd.print(event.temperature, 1);
    lcd.print(F(" C  "));
  }

  // Presenteer de vochtigheid
  dht.humidity().getEvent(&event);
  if (isnan(event.relative_humidity)) {
    lcd.setCursor(0, 1);
    lcd.print(F("   Error  reading   "));
    lcd.setCursor(0, 3);
    lcd.print(F("     humidity!      "));
  }
  else {
    lcd.setCursor(0, 2);
    lcd.print("Hygr.:   ");
    lcd.print(event.relative_humidity, 1);
    lcd.print(F(" %  "));

    // Regel bevochtigen
    if (event.relative_humidity <= BevochtigerLow && !BevochtigerAan)
    {
      digitalWrite(SmokePin, LOW);
      delay(100);
      digitalWrite(SmokePin, HIGH);

      BevochtigerAan = true;
    }

    if (event.relative_humidity >= BevochtigerHigh && BevochtigerAan)
    {
      digitalWrite(SmokePin, LOW);
      delay(100);
      digitalWrite(SmokePin, HIGH);

      BevochtigerAan = false;
    }
  }
}
