
/*
  TEST ENS160+AHT21
  a 20231201 start testing.

  Wemos
  SCL   D1
  SDA   D2

*/

/***************************************************************************
  ENS160 - Digital Air Quality Sensor
  
  This is an example for ENS160 basic reading in standard mode
    
  Updated by Sciosense / 25-Nov-2021
 ***************************************************************************/

#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128  // OLED display width, in pixels
#define SCREEN_HEIGHT 64  // OLED display height, in pixels

#define OLED_RESET -1        // Reset pin # (or -1 if sharing Arduino reset pin)
#define SCREEN_ADDRESS 0x3C  ///< See datasheet for Address; 0x3D for 128x64, 0x3C for 128x32
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

#include <Wire.h>
int ArduinoLED = 2;

///// AHT20 start
#include <Adafruit_AHTX0.h>

Adafruit_AHTX0 aht;

//Variables  Tim, reused same names so I did not have to change much.
int tempC;     //To store the temperature in C
int humidity;  //To store the humidity
///// AHT20 end

#include "ScioSense_ENS160.h"  // ENS160 library
//ScioSense_ENS160      ens160(ENS160_I2CADDR_0); //0x52
ScioSense_ENS160 ens160(ENS160_I2CADDR_1);  //0x53..ENS160+AHT21

int offset = 15;

/*--------------------------------------------------------------------------
  SETUP function
  initiate sensor
 --------------------------------------------------------------------------*/
void setup() {

  Serial.begin(9600);

  // SSD1306_SWITCHCAPVCC = generate display voltage from 3.3V internally
  if (!display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS)) {
    Serial.println(F("SSD1306 allocation failed"));
    for (;;)
      ;  // Don't proceed, loop forever
  }

  // Show initial display buffer contents on the screen --
  // the library initializes this with an Adafruit splash screen.
  display.display();
  delay(2000);  // Pause for 2 seconds

  // Clear the buffer
  display.clearDisplay();

  display.setTextSize(1);               // Normal 1:1 pixel scale
  display.setTextColor(SSD1306_WHITE);  // Draw white text
  display.setCursor(0, 0);              // Start at top-left corner
  display.cp437(true);                  // Use full 256 char 'Code Page 437' font

  display.println("** Lucht kwaliteit **");
  display.display();

  while (!Serial) {}

  //Switch on LED for init
  pinMode(ArduinoLED, OUTPUT);
  digitalWrite(ArduinoLED, LOW);

  Serial.println("------------------------------------------------------------");
  Serial.println("ENS160 - Digital air quality sensor");
  Serial.println();
  Serial.println("Sensor readout in standard mode");
  Serial.println();
  Serial.println("------------------------------------------------------------");
  delay(1000);

  Serial.print("ENS160...");
  ens160.begin();
  Serial.println(ens160.available() ? "done." : "failed!");
  if (ens160.available()) {
    // Print ENS160 versions
    Serial.print("\tRev: ");
    Serial.print(ens160.getMajorRev());
    Serial.print(".");
    Serial.print(ens160.getMinorRev());
    Serial.print(".");
    Serial.println(ens160.getBuild());

    Serial.print("\tStandard mode ");
    Serial.println(ens160.setMode(ENS160_OPMODE_STD) ? "done." : "failed!");
  }

  // AHT20 start
  Serial.println("Adafruit AHT10/AHT20 demo!");

  if (!aht.begin()) {
    Serial.println("Could not find AHT? Check wiring");
    while (1) delay(10);
  }
  Serial.println("AHT10 or AHT20 found");
  //AHT20 end

}  // end void setup

/*--------------------------------------------------------------------------
  MAIN LOOP FUNCTION
  Cylce every 1000ms and perform measurement
 --------------------------------------------------------------------------*/

void loop() {


  ///// AHT20 start
  sensors_event_t humidity1, temp;  //Tim had to change to  humidity1
  aht.getEvent(&humidity1, &temp);  // populate temp and humidity objects with fresh data

  tempC = (temp.temperature);
  // tempF = (temp.temperature)*1.8+32;
  humidity = (humidity1.relative_humidity);
  Serial.print("Temperature: ");
  Serial.print(tempC);
  Serial.println(" degrees C");
  Serial.print("Temperature: ");
  // Serial.print(tempF);
  // Serial.println(" degrees F");
  Serial.print("Humidity: ");
  Serial.print(humidity);

  Serial.print(" / ");
  Serial.print(humidity * (49.0 / 57.0), 0);

  Serial.println("% rH");

  ///// AHT20 end

  if (ens160.available()) {

    // Give values to Air Quality Sensor.
    ens160.set_envdata(tempC, humidity);

    ens160.measure(true);
    ens160.measureRaw(true);

    Serial.print("AQI: ");
    Serial.print(ens160.getAQI());
    Serial.print("\t");
    Serial.print("TVOC: ");
    Serial.print(ens160.getTVOC());
    Serial.print(" ppb");
    Serial.print(" / ");
    Serial.print(ens160.getTVOC() * 0.0045);
    Serial.print(" mg/m3\t");

    Serial.print("eCO2: ");
    Serial.print(ens160.geteCO2());
    Serial.println(" ppm\t");

    Serial.println("");

    Serial.print("R HP0: ");
    Serial.print(ens160.getHP0());
    Serial.print(" Ohm\t");
    Serial.print("R HP1: ");
    Serial.print(ens160.getHP1());
    Serial.print(" Ohm\t");
    Serial.print("R HP2: ");
    Serial.print(ens160.getHP2());
    Serial.print(" Ohm\t");
    Serial.print("R HP3: ");
    Serial.print(ens160.getHP3());
    Serial.println(" Ohm");
    Serial.println();
  } else {
    Serial.println("Error reading sensor");
    display.fillRect(0, offset, 128, 64 - offset, SSD1306_BLACK);
    display.setCursor(0, offset);
    display.println("Error reading sensor");
  }



  display.fillRect(0, offset, 128, 64 - offset, SSD1306_BLACK);

  display.setCursor(0, offset);
  display.print("Temp: ");
  display.print(tempC);
  display.print(" C  ");
  display.setCursor(0, offset + 10);
  display.print("hygr: ");
  display.print(humidity);
  display.print("% /  ");
  display.print(humidity * (49.0 / 57.0), 0);
  display.print("% rH");
  display.setCursor(0, offset + 20);
  display.print("AQI: ");
  display.print(ens160.getAQI());
  display.print("  eCO2: ");
  display.print(ens160.geteCO2());
  display.println(" ppm");
  display.setCursor(0, offset + 30);
  display.print("TVOC: ");
  display.print(ens160.getTVOC());
  display.print(" ppb");
  display.setCursor(0, offset + 40);
  display.print("      ");
  display.print(ens160.getTVOC() * 0.0045);
  display.print(" mg/m3");



  display.display();

  delay(1000);


}  //end void loop
