#include <Wire.h>
#include "Adafruit_MCP23017.h"

// Basic pin reading and pullup test for the MCP23017 I/O expander
// public domain!

// Connect pin #12 of the expander to Analog 21 (i2c clock)
// Connect pin #13 of the expander to Analog 20 (i2c data)
// Connect reset to pin 4 (PWI)

Adafruit_MCP23017 mcpRow;
Adafruit_MCP23017 mcpCol;

int dl = 25;

void setup() {

  // Reset the chip
  pinMode(4, OUTPUT);
  digitalWrite(4, LOW);
  delay(20);
  pinMode(4, INPUT);

  mcpRow.begin(0);      // use default address 0
  mcpCol.begin(1);      // use default address 1

  for (int t = 0; t < 16; t++)
  {
    // row
    mcpRow.pinMode(t, OUTPUT);

    // col
    mcpCol.pinMode(t, OUTPUT);
    mcpCol.digitalWrite(t, HIGH);
  }

  // Init randomizer
  randomSeed(analogRead(0));

  // LED test
  for (int row = 0; row < 14; row++)
  {
    int dl = 50;

    for (int col = 0; col < 10; col++)
    {
      mcpRow.digitalWrite(row, HIGH);
      mcpCol.digitalWrite(col, LOW);

      delay(dl);

      mcpRow.digitalWrite(row, LOW);
      mcpCol.digitalWrite(col, HIGH);

      delay(dl);
    }
  }
}

void loop() {

  int row = random(0, 14);
  int col = random(0, 10);

  mcpRow.digitalWrite(row, HIGH);
  mcpCol.digitalWrite(col, LOW);

  delay(dl);

  mcpRow.digitalWrite(row, LOW);
  mcpCol.digitalWrite(col, HIGH);

  delay(dl);
}
